# coding: utf-8
from collections import namedtuple

from flask_principal import Permission

from .dao import AccessRight
import six


# e.g access to module 'toggle' with role 'viewer'
AccessNeed = namedtuple('AccessNeed', ['module', 'role'])


def get_parent_modules(module):
    """Returns all parent modules of `module`. I.e., "a.b.c" -> ["a.b.c", "a.b". "a"].

    :type module: str
    :returns: [str]
    """
    rv = []
    segments = module.split('.')
    for i in six.moves.xrange(len(segments)):
        rv.append('.'.join(segments[:(i + 1)]))
    return rv


def get_module_permission(module):
    """Returns all parent modules of `module`. I.e., "a.b.c" -> ["a.b.c", "a.b". "a"].

    :type module: str
    :returns: :class:`flask.ext.principal.Permission`
    """
    needs = set()
    for module in get_parent_modules(module):
        needs.add(AccessNeed(module, AccessRight.Write))
    return Permission(*needs)
