"""Provides various handy decorators."""

from __future__ import unicode_literals

import six
from functools import wraps

from flask import render_template_string
import library.python.resource as resource


def templated(template_name):
    """Renders the returned value using the specified template."""

    def decorator(func):
        @wraps(func)
        def decorated(*args, **kwargs):
            if not resource.resfs_file_exists(template_name):
                raise RuntimeError("Fail to find template {}".format(template_name))
            ctx = func(*args, **kwargs) or {}
            return render_template_string(six.ensure_str(resource.resfs_read(template_name)), **ctx)

        return decorated

    return decorator
