"""
Flask application perfomance managing augmentation.
"""
from flask import g, request

from sepelib.metrics.registry import metrics_inventory


class PerfCounter(object):
    def __init__(self, name='/services/http'):
        self._registry = metrics_inventory.get_metrics(name)

    def augment(self, app):
        """
        :param app: flask application to augment
        """
        app.before_request(self._before_request)
        app.teardown_request(self._teardown_request)

    def _before_request(self):
        if request.endpoint is not None:
            g._url_perf_timer = self._registry.timer(request.endpoint).time()
            g._total_perf_timer = self._registry.timer('total').time()

    def _teardown_request(self, _=None):
        t = getattr(g, '_url_perf_timer', None)
        if t is not None:
            t.stop()
        t = getattr(g, '_total_perf_timer', None)
        if t is not None:
            t.stop()

    def get_snapshot(self):
        return {'rule_timings': self._registry.dump_metrics()}
