"""Flask application status code managing augmentation."""

from flask import request

from sepelib.metrics.registry import metrics_inventory


class StatusCounter(object):
    def __init__(self, prefix='/services/http/statuses/'):
        self._registry = {metric_name: metrics_inventory.get_metrics(prefix + metric_name)
                          for metric_name in ('1xx', '2xx', '3xx', '404', '4xx', '5xx', 'xxx')}

    def augment(self, app):
        app.after_request(self._after_request)

    def _after_request(self, response):
        status_code = response.status_code
        status_class = status_code // 100

        if status_code == 404:
            metric_name = '404'
        elif 1 <= status_class <= 5:
            metric_name = '{}xx'.format(status_class)
        else:
            metric_name = 'xxx'

        registry = self._registry[metric_name]
        target = request.endpoint or 'invalid'

        registry.counter(target).inc()
        registry.counter('total').inc()

        return response
