import logging
import functools

import gevent


class GreenThread(object):
    """
    A simple green runnable.
    Override method "run" and be good.
    """
    def __init__(self):
        self.__main_task = None

    @staticmethod
    def _log_exception(func):
        @functools.wraps(func)
        def wrapper(*args, **kwargs):
            try:
                func(*args, **kwargs)
            except gevent.GreenletExit:
                raise
            except:
                logging.getLogger().exception("the greenlet died because of unhandled exception")
        return wrapper

    def run(self):
        raise NotImplementedError

    def start(self):
        if self.__main_task is None:
            self.__main_task = gevent.spawn(self._log_exception(self.run))

    def wait(self, timeout=None):
        if self.__main_task is None:
            raise RuntimeError("green thread is not running")
        return self.__main_task.get(timeout=timeout)

    def stop(self):
        if self.__main_task is None:
            return
        self.__main_task.kill()
        self.__main_task = None

    def ready(self):
        return self.__main_task.ready()
