import time
from .histogram import Histogram
import uuid


class Timer(object):
    __slots__ = ['clock', 'hist', 'uuid']

    def __init__(self, clock=time):
        super(Timer, self).__init__()
        self.clock = clock
        self.uuid = str(uuid.uuid4())
        self.hist = Histogram(clock=clock)

    def get_count(self):
        return self.hist.get_count()

    def get_sum(self):
        return self.hist.get_sum()

    def get_max(self):
        return self.hist.get_max()

    def get_min(self):
        return self.hist.get_min()

    def get_mean(self):
        return self.hist.get_mean()

    def get_stddev(self):
        return self.hist.get_stddev()

    def get_var(self):
        return self.hist.get_var()

    def get_snapshot(self):
        return self.hist.get_snapshot()

    def update(self, seconds):
        if seconds >= 0:
            self.hist.add(seconds)

    def time(self, *args, **kwargs):
        """
        Parameters will be sent to signal, if fired.
        """
        return TimerContext(self, self.clock, *args, **kwargs)

    def clear(self):
        self.uuid = str(uuid.uuid4())
        self.hist.clear()

    def get_yasm_format_metrics(self):
        return {
            'timer_ahhh': self.get_snapshot().get_histogram(),
            'count_summ': self.get_count(),
        }


class TimerContext(object):
    __slots__ = ['clock', 'timer', 'start_time', 'kwargs', 'args']

    def __init__(self, timer, clock, *args, **kwargs):
        super(TimerContext, self).__init__()
        self.clock = clock
        self.timer = timer
        self.start_time = self.clock.time()
        self.kwargs = kwargs
        self.args = args

    def stop(self):
        elapsed = self.clock.time() - self.start_time
        self.timer.update(elapsed)
        return elapsed

    def __enter__(self):
        pass

    def __exit__(self, t, v, tb):
        self.stop()
