"""Provides a functionality to generate monotonically increasing numbers.

MongoEngine's SequenceField provides the same functionality by it's too implicit and error-prone.
"""

from __future__ import unicode_literals

from mongoengine import DynamicDocument, StringField, LongField

import sepelib.mongo.util
from sepelib.mongo.util import register_model

sepelib.mongo.util.patch()


@register_model
class _MonotonicNumbers(DynamicDocument):
    id = StringField(primary_key=True)
    next = LongField(required=True)

    meta = {"collection": "monotonic_numbers"}


def get_next(namespace):
    """Returns a next monotonically increasing number for the specified namespace."""

    numbers = _MonotonicNumbers.objects(id=namespace).modify(inc__next=1, upsert=True)
    return 0 if numbers is None else numbers.next
