"""Process manipulation utilities."""

from __future__ import unicode_literals

import errno
import time


def terminate(process, kill_after=5):
    """Graceful termination."""

    termination_timeout = time.time() + kill_after

    while True:
        try:
            process.terminate()
        except EnvironmentError as e:
            if e.errno == errno.ESRCH:
                return

            raise

        if time.time() >= termination_timeout:
            break

        time.sleep(0.1)

    try:
        process.kill()
    except EnvironmentError as e:
        if e.errno == errno.ESRCH:
            return

        raise

    process.wait()
