import six


def format_exc(msg, e):
    """
    Pretty format exception, it's like perror.
    :param msg: message to prepend
    :param e: exception to format
    """
    args = msg, e.__class__.__name__, " ".join(six.ensure_str(str(i), 'utf-8') for i in e.args)
    return "{0}: type='{1}' args='{2}'".format(*args)
