"""Miscellaneous utilities."""

from __future__ import unicode_literals

from sepelib.core.exceptions import Error
import six


def doesnt_override(klass):
    """A decorator which ensures that a class doesn't override anything from it's base classes."""

    def decorator(method):
        if hasattr(klass, method.__name__):
            raise Error("{} overrides {}.{}.", method.__name__, klass.__name__, method.__name__)
        return method

    return decorator


def drop_none(d, none=None):
    """Drop keys with None values"""

    return {k: v for k, v in six.iteritems(d) if v is not none}
