"""
Freebsd version using SO_PEERCRED.
"""
import os
import socket
import struct
import errno

__all__ = ['getpeerid']


_LOCAL_PEERCRED = 0x001
_NGROUPS = 16


#struct xucred {
#        u_int   cr_version;             /* structure layout version */
#        uid_t   cr_uid;                 /* effective user id */
#        short   cr_ngroups;             /* number of groups */
#        gid_t   cr_groups[NGROUPS];     /* groups */
#        void    *_cr_unused1;           /* compatibility with old ucred */
#};

_structxucred = struct.Struct('2ih{0}iP'.format(_NGROUPS))


def getpeerid(sock):
    """
    Return user id of process on remote side of UNIX domain socket.
    :param sock: fileobject
    :rtype: int
    """
    res = sock.getsockopt(socket.SOL_IP, _LOCAL_PEERCRED, _structxucred.size)

    # we will receive invalid res (filled with zeroes) on invalid socket
    if len(res) < _structxucred.size:
        raise OSError(errno.EINVAL, os.strerror(errno.EINVAL))
    res = _structxucred.unpack(res)
    return int(res[1])
