"""
Linux version via SO_PEERCRED.
"""
import os
import struct
import socket
import errno

# hopefully they don't break ABI
# SO_PEERCRED is defined only in python3.3
SO_PEERCRED = 17


def getpeerid(sock):
    """
    Return user id of process on remote side of UNIX domain socket.
    :param sock: fileobject
    :rtype: int
    """
    res = sock.getsockopt(socket.SOL_SOCKET, SO_PEERCRED, struct.calcsize('3i'))
    pid, uid, gid = struct.unpack('3i', res)
    # seems that in case of bad socket (e.g. AF_INET)
    # we are getting 0, -1, -1 as pid, uid, gid accordingly
    # so let's manually raise EINVAL
    if pid == 0:
        raise OSError(errno.EINVAL, os.strerror(errno.EINVAL))
    return uid
