"""
Simple decorator to measure execution time
"""
import time


def time_it(f):
    def wrapper(*args, **kw):
        start = time.time()
        print("started func='{}'".format(f.__name__))
        try:
            return f(*args, **kw)
        finally:
            print("finished func='{}' in {:0.4f} sec".format(
                f.__name__, (time.time()- start)))
    return wrapper
