# -*- coding: utf-8 -*-
"""
Nanny (https://wiki.yandex-team.ru/JandeksPoisk/Sepe/nanny/rest-api) client.

THIS FILE IS NOT SUPPORTED ANYMORE, AND PROBABLY OUTDATED, PLEASE DON'T USE IT
"""
from collections import namedtuple

import requests
import gevent
from enum import Enum
from object_validator import DictScheme, String, List, Integer, Dict, InvalidValueError, Bool

from sepelib.yandex import ApiRequestException
from sepelib.http.session import InstrumentedSession
from sepelib.http.request import json_request
from sepelib.yandex.alemate import Instance, ContainerResourceLimits, Iss3HooksTimeLimits, MetaData, \
    Iss3HooksResourceLimits


class NannyApiRequestException(ApiRequestException):
    """Common-case exception for Nanny request"""
    pass


class Resources(namedtuple('Resources',
                           ['sandbox_bsc_shard',
                            'static_files',
                            'sandbox_files',
                            'url_files',
                            'template_set_files',
                            'l7_fast_balancer_config_template_files',
                            'services_balancer_config_template_files'])):
    @classmethod
    def from_dict(cls, params):
        kwargs = {f: params[f] for f in cls._fields}
        return cls(**kwargs)


class Template(namedtuple('Template', ['name', 'content'])):
    @classmethod
    def from_dict(cls, params):
        kwargs = {f: params[f] for f in cls._fields}
        return cls(**kwargs)


class SandboxResource(namedtuple('SandboxResource', ['task_id', 'task_type', 'resource_type'])):
    @classmethod
    def from_dict(cls, params):
        kwargs = {f: params[f] for f in cls._fields}
        return cls(**kwargs)


class BundleShard(object):

    __slots__ = ['source_resources', 'shard_prefix', 'resource_type', 'release_after_build']

    @classmethod
    def from_dict(cls, params):
        return cls(**params)

    def __init__(self, source_resources, shard_prefix, resource_type, release_after_build=False, **_):
        self.source_resources = source_resources
        self.shard_prefix = shard_prefix
        self.resource_type = resource_type
        self.release_after_build = release_after_build

    def __repr__(self):
        kwargs_str = []
        for attr in self.__slots__:
            kwargs_str.append('{}={!r}'.format(attr, getattr(self, attr, None)))
        return 'BundleShard({})'.format(kwargs_str)

    __str__ = __repr__


class RegisteredShard(object):
    __slots__ = ['shard_id']

    @classmethod
    def from_dict(cls, d):
        return cls(d['shard_id'])

    def __init__(self, shard_id):
        self.shard_id = shard_id

    def __repr__(self):
        return "RegisteredShard(shard_id: {})".format(self.shard_id)

    __str__ = __repr__


class SandboxBsconfigShard(object):
    def __init__(self,
                 chosen_type='SANDBOX_SHARD',
                 task_id=None,
                 task_type=None,
                 resource_type=None,
                 bundle_shard=None,
                 registered_shard=None,
                 sandbox_shardmap=None,
                 local_path=None,
                 download_queue=None,
                 download_speed=None,
                 **_):
        """
        :type chosen_type: str | unicode
        :type task_id: str | unicode
        :type task_type: str | unicode
        :type resource_type: str | unicode
        :type bundle_shard: BundleShard
        :type registered_shard: RegisteredShard
        :type sandbox_shardmap: SandboxResource
        :type local_path: str | unicode
        :type download_queue: str | unicode
        :type download_speed: int
        """
        self.chosen_type = chosen_type
        self.task_id = task_id
        self.task_type = task_type
        self.resource_type = resource_type
        self.bundle_shard = bundle_shard
        self.registered_shard = registered_shard
        self.sandbox_shardmap = sandbox_shardmap
        self.local_path = local_path
        self.download_queue = download_queue
        self.download_speed = download_speed

    @classmethod
    def _convert_bundle_shard(cls, bundle_shard):
        return BundleShard(
            source_resources=[SandboxResource.from_dict(r) for r in bundle_shard['source_resources']],
            shard_prefix=bundle_shard['shard_prefix'],
            resource_type=bundle_shard['resource_type'],
            release_after_build=bundle_shard.get('release_after_build', False),
        )

    @classmethod
    def from_dict(cls, params):
        params = params.copy()
        if 'bundle_shard' in params:
            params['bundle_shard'] = cls._convert_bundle_shard(params['bundle_shard'])
        if 'registered_shard' in params:
            params['registered_shard'] = RegisteredShard.from_dict(params['registered_shard'])
        if 'sandbox_shardmap' in params:
            params['sandbox_shardmap'] = SandboxResource.from_dict(params['sandbox_shardmap'])
        return cls(**params)


class ServiceResources(Resources):
    """Service resources description"""

    class StaticFile(namedtuple('StaticFile', ['local_path',
                                               'is_dynamic',
                                               'content',
                                               'download_queue',
                                               'download_speed',
                                               ])):
        @classmethod
        def from_dict(cls, d):
            return cls(
                local_path=d['local_path'],
                is_dynamic=d.get('is_dynamic', False),
                download_queue=d.get('download_queue', None),
                download_speed=d.get('download_speed', None),
                content=d['content']
            )

    class SandboxFile(namedtuple('SandboxFile', ['local_path', 'is_dynamic', 'task_id', 'task_type', 'resource_type',
                                                 'download_queue', 'download_speed'])):
        @classmethod
        def from_dict(cls, d):
            return cls(
                local_path=d['local_path'],
                is_dynamic=d.get('is_dynamic', False),
                download_queue=d.get('download_queue', None),
                download_speed=d.get('download_speed', None),
                task_id=d['task_id'],
                task_type=d['task_type'],
                resource_type=d['resource_type']
            )

    class UrlFile(namedtuple('UrlFile', ['local_path', 'is_dynamic', 'url', 'chksum',
                                         'download_queue', 'download_speed'])):
        @classmethod
        def from_dict(cls, d):
            return cls(
                local_path=d['local_path'],
                is_dynamic=d.get('is_dynamic', False),
                download_queue=d.get('download_queue', None),
                download_speed=d.get('download_speed', None),
                url=d['url'],
                chksum=d.get('chksum')
            )

    class TemplateSetFile(
        namedtuple('TemplateSetFile', ['local_path', 'is_dynamic', 'layout', 'templates',
                                       'download_queue', 'download_speed'])):
        @classmethod
        def from_dict(cls, d):
            return cls(
                local_path=d['local_path'],
                is_dynamic=d.get('is_dynamic', False),
                download_queue=d.get('download_queue', None),
                download_speed=d.get('download_speed', None),
                layout=d['layout'],
                templates=[Template.from_dict(i) for i in d['templates']]
            )

    class BalancingOptionsMixin(object):
        BALANCING_TYPES = ['weighted2', 'rr', 'hashing']

        @classmethod
        def _convert_balancing_type_mode(cls, mode, balancing_type, required=True):
            if mode == 'hashing':
                if not required and 'mode' not in balancing_type:
                    return {}
                mode = balancing_type['mode']
                description = balancing_type.get(mode)
                if description is None:
                    if required:
                        raise NannyApiRequestException('No description for selected "{}" hashing type '
                                                       'found'.format(mode))
                    else:
                        return {"mode": {mode: {}}}
                balancing_type = {"mode": {mode: description}}
            return balancing_type

        @classmethod
        def _convert_balancing_type(cls, balancing_type, required=True):
            if not required and 'mode' not in balancing_type:
                return {}
            mode = balancing_type['mode']
            result = balancing_type.get(mode)

            if result is None:
                if required and mode != 'rr':
                    raise NannyApiRequestException('No description for selected "{}" balancing type '
                                                   'found'.format(mode))
                else:
                    return {mode: {}}

            return {mode: cls._convert_balancing_type_mode(mode, result, required=required)}

        @classmethod
        def _convert_balancing_options(cls, balancing_options, required=True):
            balancing_options = balancing_options.copy()
            if required or 'balancing_type' in balancing_options:
                balancing_options['balancing_type'] = cls._convert_balancing_type(balancing_options['balancing_type'],
                                                                                  required=required)
            return balancing_options

    class ServicesBalancerConfigTemplateFile(BalancingOptionsMixin,
                                             namedtuple('ServicesBalancerConfigTemplateFile',
                                                        ['local_path',
                                                         'is_dynamic',
                                                         'content',
                                                         'download_queue',
                                                         'download_speed'])):
        Content = namedtuple('Content', ['addr_list', 'admin_addr_list', 'ssl_settings', 'sections', 'use_ipv6_only'])
        Address = namedtuple('Address', ['ip', 'port', 'use_instance_addr', 'ssl_enable'])
        SSLSettings = namedtuple('SSLSettings', ['cert', 'priv'])
        Matcher = namedtuple('Matcher', ['prefix', 'host'])
        Header = namedtuple('Header', ['name', 'type', 'value'])
        Section = namedtuple('BalancerSection', ['id', 'matcher', 'headers', 'balancing_options', 'traffic_slices'])
        TrafficSlice = namedtuple('TrafficSlice', ['name', 'weight', 'balancing_options', 'backend'])
        Backend = namedtuple('BackendSettings', ['service_id', 'snapshot_id'])

        @classmethod
        def _backend_from_dict(cls, params):
            return cls.Backend(
                service_id=params['service_id'],
                snapshot_id=params['snapshot_id']
            )

        @classmethod
        def _traffic_slice_from_dict(cls, params):
            return cls.TrafficSlice(
                name=params['name'],
                weight=params['weight'],
                balancing_options=cls._convert_balancing_options(params['balancing_options'], required=False),
                backend=cls._backend_from_dict(params['backend'])
            )

        @classmethod
        def _addr_from_dict(cls, params):
            return cls.Address(
                ip=params.get('ip', None),
                port=params['port'],
                use_instance_addr=params.get('use_instance_addr', False),
                ssl_enable=params.get('ssl_enable', False)
            )

        @classmethod
        def _matcher_from_dict(cls, params):
            return cls.Matcher(
                prefix=params.get('prefix'),
                host=params['host']
            )

        @classmethod
        def _header_from_dict(cls, params):
            return cls.Header(
                name=params['name'],
                type=params['type'],
                value=params['value']
            )

        @classmethod
        def _section_from_dict(cls, params):
            return cls.Section(
                id=params['id'],
                matcher=cls._matcher_from_dict(params['matcher']),
                headers=[cls._header_from_dict(h) for h in params['headers']],
                balancing_options=cls._convert_balancing_options(params['balancing_options']),
                traffic_slices=[cls._traffic_slice_from_dict(ts) for ts in params['traffic_slices']]
            )

        @classmethod
        def _content_from_dict(cls, params):
            # Migration from addr to addr_list in progress: SWAT-2475
            addrs = []
            raw_addrs = params.get('addr_list', [])
            if 'addr' in params:
                raw_addrs.append(params['addr'])
            for x in raw_addrs:
                addr = cls._addr_from_dict(x)
                if addr not in addrs:
                    addrs.append(addr)
            if len(addrs) == 0:
                raise NannyApiRequestException('Zero length addr_list')

            admin_addrs = []
            raw_admin_addrs = params.get('admin_addr_list', [])
            if 'admin_addr' in params:
                raw_admin_addrs.append(params['admin_addr'])
            for x in raw_admin_addrs:
                addr = cls._addr_from_dict(x)
                if addr not in admin_addrs:
                    admin_addrs.append(addr)
            if len(admin_addrs) == 0:
                raise NannyApiRequestException('Zero length admin_addr_list')

            ssl_params = params.get('ssl_settings', {})
            ssl_settings = cls.SSLSettings(
                cert=ssl_params.get('cert', ''),
                priv=ssl_params.get('priv', ''),
            )
            use_ipv6_only = params.get('use_ipv6_only', False)

            return cls.Content(
                addr_list=addrs,
                admin_addr_list=admin_addrs,
                ssl_settings=ssl_settings,
                sections=[cls._section_from_dict(s) for s in params['sections']],
                use_ipv6_only=use_ipv6_only
            )

        @classmethod
        def from_dict(cls, params):
            return cls(
                local_path=params['local_path'],
                is_dynamic=params.get('is_dynamic', False),
                download_queue=params.get('download_queue', None),
                download_speed=params.get('download_speed', None),
                content=cls._content_from_dict(params['content'])
            )

    class L7FastBalancerConfigTemplateFile(BalancingOptionsMixin,
                                           namedtuple('L7FastBalancerConfigTemplateFile',
                                                      ['local_path',
                                                       'is_dynamic',
                                                       'content',
                                                       'download_queue',
                                                       'download_speed'])):
        Content = namedtuple('Content', ['default_port', 'default_admin_port', 'main_domain', 'secaudited_section_ids', 'sections'])
        Section = namedtuple('Section', ['id', 'prefix', 'https_required', 'balancing_options', 'top_level_domains'])
        TopLevelDomain = namedtuple('TopLevelDomain', ['domains', 'groups'])
        Group = namedtuple('Group', ['name', 'service_id', 'snapshot_id', 'balancing_options'])

        @classmethod
        def _group_from_dict(cls, params):
            if 'balancing_options' in params:
                balancing_options = cls._convert_balancing_options(params['balancing_options'], required=False)
            else:
                balancing_options = None

            return cls.Group(
                name=params['name'],
                service_id=params['service_id'],
                snapshot_id=params['snapshot_id'],
                balancing_options=balancing_options
            )

        @classmethod
        def _top_level_domain_from_dict(cls, params):
            return cls.TopLevelDomain(
                domains=params['domains'],
                groups=[cls._group_from_dict(i) for i in params['groups']]
            )

        @classmethod
        def _section_from_dict(cls, params):
            return cls.Section(
                id=params['id'],
                prefix=params['prefix'],
                https_required=params['https_required'],
                balancing_options=cls._convert_balancing_options(params['balancing_options']),
                top_level_domains=[cls._top_level_domain_from_dict(i) for i in params['top_level_domains']]
            )

        @classmethod
        def _content_from_dict(cls, params):
            return cls.Content(
                default_port=params.get('default_port'),
                default_admin_port=params.get('default_admin_port'),
                main_domain=params.get('main_domain'),
                secaudited_section_ids=params.get('secaudited_section_ids', []),
                sections=[cls._section_from_dict(i) for i in params['sections']]
            )

        @classmethod
        def from_dict(cls, params):
            return cls(
                local_path=params['local_path'],
                is_dynamic=params.get('is_dynamic', False),
                download_queue=params.get('download_queue', None),
                download_speed=params.get('download_speed', None),
                content=cls._content_from_dict(params['content'])
            )


class BsconfigResource(object):
    """
        Описание ресурса CMS
    """
    __slots__ = ['name', 'remote_path', 'local_path', 'chksum', 'arch', 'instances', 'short_name', 'is_dynamic',
                 'download_queue', 'download_speed']

    def __init__(self, name, remote_path, local_path, chksum, arch, instances=None, short_name=None, is_dynamic=False,
                 download_queue=None, download_speed=None):
        self.name = name
        self.short_name = short_name
        self.remote_path = remote_path
        self.local_path = local_path
        self.chksum = chksum
        self.arch = arch
        self.instances = instances if instances else []
        self.is_dynamic = is_dynamic
        self.download_queue = download_queue
        self.download_speed = download_speed

    @classmethod
    def from_dict(cls, params):
        return cls(**params)

    def __eq__(self, other):
        return self.__slots__ == other.__slots__ and all(getattr(self, f) == getattr(other, f) for f in self.__slots__)

    def __repr__(self):
        return "BsconfigResource(" \
               "name='{}', short_name='{}', remote_path={}, local_path={}, chksum='{}', arch='{}', instances={}'" \
               ")".format(self.name, self.short_name, self.remote_path,
                          self.local_path, self.chksum, self.arch, self.instances)

    __str__ = __repr__

    def to_cms_format(self):
        return self.name, self.remote_path, self.local_path, self.chksum, self.arch


class BsconfigShard(object):
    """
        Описание шарда CMS
    """
    __slots__ = ['name', 'chksum', 'mtime', 'resource_url', 'priority', 'shard_num', 'instances']

    def __init__(self, name, chksum, mtime, resource_url, priority=0, shard_num=-1, instances=None, **_):
        """

        :param name: название шарда
        :param chksum: чексумма для файлов шарда (хитрая штука, лучше извне не пользовать при своих вычислениях chksum)
            (по информации от @nekto0n это md5 от файла shard.conf)
            Лучше использовать checksum от торрента.
        :param mtime: время последнего изменения шарда (ctime)
        :param resource_url: url в виде торрента
        :param priority: приоритет шарда в виде числа, известными системами не используется
        :param shard_num: присваивается при инициализации в роботе - смысл скрыт, никем не используется
        :param instances: список инстансов шарда
        :return:
        """
        self.name = name
        self.chksum = chksum
        self.mtime = mtime
        self.resource_url = resource_url
        self.priority = priority
        self.shard_num = shard_num
        self.instances = instances if instances else []

    def __repr__(self):
        return "BsconfigShard(name='{}', chksum='{}', mtime={}, resource_url={}, priority={}, shard_num={}, " \
               "instances={})".format(self.name, self.chksum, self.mtime, self.resource_url, self.priority,
                                      self.shard_num, self.instances)

    __str__ = __repr__


class ServiceInstances(object):
    """Service instances description"""

    __slots__ = ['chosen_type', 'instance_list', 'gencfg_groups', 'allocation_id', 'allocation_ids', 'iss_settings',
                 'extended_allocations', 'extended_gencfg_groups', 'customizable_extended_allocations']

    class GencfgGroup(object):

        __slots__ = ['name', 'release', 'tags', 'limits']

        def __init__(self, name, release='trunk', tags=None, limits=None):
            self.name = name
            self.release = release
            self.tags = tags or []
            self.limits = limits

        @classmethod
        def from_dict(cls, params):
            if 'limits' in params:
                params['limits'] = ContainerResourceLimits.from_nanny_response(params['limits'])
            else:
                params['limits'] = None
            kwargs = {f: params[f] for f in cls.__slots__}
            return cls(**kwargs)

        def __repr__(self):
            return 'GencfgGroup(release={!r}, group={!r})'.format(self.release, self.name)

    class ExtendedAllocation(object):

        __slots__ = ['allocation_id', 'tags', 'limits']

        def __init__(self, allocation_id, tags=None, limits=None):
            self.allocation_id = allocation_id
            self.tags = tags or []
            self.limits = limits

        @classmethod
        def from_dict(cls, params):
            if 'limits' in params:
                params['limits'] = ContainerResourceLimits.from_nanny_response(params['limits'])
            else:
                params['limits'] = ContainerResourceLimits()
            return cls(**{f: params.get(f) for f in cls.__slots__})

    class CustomizableExtendedAllocation(object):
        __slots__ = ['tags', 'allocations']

        def __init__(self, tags, allocations):
            self.tags = tags
            self.allocations = allocations

        @classmethod
        def from_dict(cls, params):
            return cls(**{f: params.get(f) for f in cls.__slots__})

    class NetworkSettings(object):

        def __init__(self, use_mtn):
            """
            :type use_mtn: bool
            """
            self.use_mtn = use_mtn

    class ExtendedGencfgGroups(object):
        __slots__ = ['tags', 'groups', 'network_settings']

        def __init__(self, tags, groups, network_settings):
            self.tags = tags
            self.groups = groups
            self.network_settings = network_settings

        @classmethod
        def from_nanny_response(cls, d):
            """
            :type d: dict
            :rtype: ServiceInstances.ExtendedGencfgGroups
            """
            tags = d.get('tags', [])
            groups = [ServiceInstances.GencfgGroup.from_dict(r) for r in d.get('groups', [])]
            use_mtn = d.get('network_settings', {}).get('use_mtn', False)
            network = ServiceInstances.NetworkSettings(use_mtn=use_mtn)
            return cls(tags=tags,
                       groups=groups,
                       network_settings=network)

    class IssSettings(object):

        __slots__ = ['instance_cls', 'hooks_time_limits', 'hooks_resource_limits']

        def __init__(self, instance_cls, hooks_time_limits=None, hooks_resource_limits=None):
            self.instance_cls = instance_cls
            self.hooks_time_limits = hooks_time_limits
            self.hooks_resource_limits = hooks_resource_limits

        @classmethod
        def from_dict(cls, params):
            return cls(
                instance_cls=params.get('instance_cls', 'ru.yandex.iss.Instance'),
                hooks_time_limits=Iss3HooksTimeLimits.from_dict(params.get('hooks_time_limits', {})),
                hooks_resource_limits=Iss3HooksResourceLimits.from_nanny_response(params.get('hooks_resource_limits',
                                                                                             {}))
            )

    class InstanceType(Enum):
        INSTANCE_LIST = 1
        GENCFG_GROUPS = 2
        ALLOCATION = 3
        ALLOCATIONS = 4
        EXTENDED_ALLOCATIONS = 5
        EXTENDED_GENCFG_GROUPS = 6
        CUSTOMIZABLE_EXTENDED_ALLOCATIONS = 7

    INSTANCE_TYPE_MAPPING = {
        'INSTANCE_LIST': InstanceType.INSTANCE_LIST,
        'GENCFG_GROUPS': InstanceType.GENCFG_GROUPS,
        'ALLOCATION': InstanceType.ALLOCATION,
        'ALLOCATIONS': InstanceType.ALLOCATIONS,
        'EXTENDED_ALLOCATIONS': InstanceType.EXTENDED_ALLOCATIONS,
        'EXTENDED_GENCFG_GROUPS': InstanceType.EXTENDED_GENCFG_GROUPS,
        'CUSTOMIZABLE_EXTENDED_ALLOCATIONS': InstanceType.CUSTOMIZABLE_EXTENDED_ALLOCATIONS,
    }

    def __init__(self, chosen_type, instance_list=None, gencfg_groups=None, allocation_id=None, allocation_ids=None,
                 extended_allocations=None, extended_gencfg_groups=None, iss_settings=None,
                 customizable_extended_allocations=None):
        self.chosen_type = chosen_type
        self.instance_list = instance_list
        self.gencfg_groups = gencfg_groups
        self.allocation_id = allocation_id
        self.allocation_ids = allocation_ids
        self.extended_allocations = extended_allocations
        self.extended_gencfg_groups = extended_gencfg_groups
        self.iss_settings = iss_settings
        self.customizable_extended_allocations = customizable_extended_allocations

    @classmethod
    def from_dict(cls, params):
        return cls(**{f: params.get(f) for f in cls.__slots__})


class ServiceEngines(namedtuple('_ServiceEngines',
                                ['engine_type'])):
    @classmethod
    def from_dict(cls, params):
        return cls(engine_type=params['engine_type'])


class ServiceRuntimeAttributes(object):
    """Service attributes description"""

    __slots__ = ['service_id', 'snapshot_id', 'resources', 'instances', 'engines', 'instance_spec']

    def __init__(self, service_id, snapshot_id, resources, instances, engines, instance_spec=None, **_):
        self.service_id = service_id
        self.snapshot_id = snapshot_id
        self.resources = resources
        self.instances = instances
        self.engines = engines
        self.instance_spec = instance_spec

    @classmethod
    def from_dict(cls, params):
        """
        :type params: dict

        Create ServiceRuntimeAttributes class from :param params: received from Nanny
        """
        snapshot_id, service_id, content = params.get('_id'), params.get('service_id'), params['content']

        shard_dict = content['resources'].get('sandbox_bsc_shard')
        sandbox_bsc_shard = None
        if shard_dict:
            sandbox_bsc_shard = SandboxBsconfigShard.from_dict(shard_dict)

        static_files = [ServiceResources.StaticFile.from_dict(r)
                        for r in content['resources'].get('static_files', [])]
        sandbox_files = [ServiceResources.SandboxFile.from_dict(r)
                         for r in content['resources'].get('sandbox_files', [])]
        url_files = [ServiceResources.UrlFile.from_dict(r)
                     for r in content['resources'].get('url_files', [])]
        template_set_files = [ServiceResources.TemplateSetFile.from_dict(d)
                              for d in content['resources'].get('template_set_files', [])]
        l7_fast_balancer_configs = [ServiceResources.L7FastBalancerConfigTemplateFile.from_dict(r)
                                    for r in content['resources'].get('l7_fast_balancer_config_files', [])]
        services_balancer_configs = [ServiceResources.ServicesBalancerConfigTemplateFile.from_dict(r)
                                     for r in content['resources'].get('services_balancer_config_files', [])]

        resources = ServiceResources(
            sandbox_bsc_shard=sandbox_bsc_shard,
            static_files=static_files,
            sandbox_files=sandbox_files,
            url_files=url_files,
            template_set_files=template_set_files,
            l7_fast_balancer_config_template_files=l7_fast_balancer_configs,
            services_balancer_config_template_files=services_balancer_configs
        )

        instances_dict = content['instances']
        instance_list = [Instance.from_dict(dict(r, power=r.get('weight')))
                         for r in instances_dict.get('instance_list', [])]
        gencfg_groups = [ServiceInstances.GencfgGroup.from_dict(r)
                         for r in instances_dict.get('gencfg_groups', [])]
        allocation_id = instances_dict.get('allocation_id')
        allocation_ids = instances_dict.get('allocation_ids')
        extended_allocations = [ServiceInstances.ExtendedAllocation.from_dict(r)
                                for r in instances_dict.get('extended_allocations', [])]
        if 'extended_gencfg_groups' in instances_dict:
            d = instances_dict['extended_gencfg_groups']
            extended_gencfg_groups = ServiceInstances.ExtendedGencfgGroups.from_nanny_response(d)
        else:
            extended_gencfg_groups = None
        if 'customizable_extended_allocations' in instances_dict:
            extended_allocations_dict = instances_dict['customizable_extended_allocations']
            customizable_extended_allocations = ServiceInstances.CustomizableExtendedAllocation.from_dict({
                'tags': extended_allocations_dict.get('tags', []),
                'allocations': [ServiceInstances.ExtendedAllocation.from_dict(r)
                                for r in extended_allocations_dict.get('allocations', [])]
            })
        else:
            customizable_extended_allocations = None
        iss_settings = ServiceInstances.IssSettings.from_dict(instances_dict.get('iss_settings', {}))
        instances = ServiceInstances(
            chosen_type=ServiceInstances.INSTANCE_TYPE_MAPPING[instances_dict['chosen_type']],
            instance_list=instance_list,
            gencfg_groups=gencfg_groups,
            extended_gencfg_groups=extended_gencfg_groups,
            allocation_id=allocation_id,
            allocation_ids=allocation_ids,
            iss_settings=iss_settings,
            extended_allocations=extended_allocations,
            customizable_extended_allocations=customizable_extended_allocations
        )
        engines = ServiceEngines.from_dict(content['engines'])
        instance_spec = content.get('instance_spec')
        return cls(service_id, snapshot_id, resources, instances, engines, instance_spec)


class AnnotatedPort(namedtuple('AnnotatedPort', ['name', 'port', 'protocol'])):
    @classmethod
    def from_dict(cls, params):
        """
        Create AnnotatedPort class from :param params: dict received from Nanny
        """
        name, port, protocol = params.get('name'), params['port'], params['protocol']
        return cls(name, port, protocol)


class AllocatedInstance(namedtuple('AllocatedInstance', ['host', 'ports', 'weight', 'tags',
                                                         'ipv4_address', 'ipv6_address', 'meta_data'])):
    @classmethod
    def from_dict(cls, params):
        """
        Create AllocatedInstance class from :param params: dict received from Nanny
        """
        host, ports, weight, tags = params['host'], params['ports'], params['weight'], params.get('tags')
        meta_data = MetaData.from_nanny_response(params.get('meta_data', {}))
        ipv4_address = params.get('ipv4_address')
        ipv6_address = params.get('ipv6_address')
        ports = [AnnotatedPort.from_dict(p) for p in ports]
        return cls(host, ports, weight, tags, ipv4_address, ipv6_address, meta_data)


class AllocationOrder(namedtuple('AllocationOrder', ['cluster', 'cpu', 'disk', 'memory'])):
    @classmethod
    def from_dict(cls, params):
        """
        Create AllocationOrder class from :param params: dict received from Nanny
        """
        return cls(params['cluster'], params['cpu'], params['disk'], params['memory'])


class Allocation(namedtuple('Allocation', ['id', 'service_id', 'instances', 'order'])):
    @classmethod
    def from_dict(cls, params):
        """
        Create Allocation class from :param params: dict received from Nanny
        """
        allocation_id, service_id, instances = params['_id'], params['service_id'], params['instances']
        order = params['order']
        return cls(allocation_id, service_id, [AllocatedInstance.from_dict(i) for i in instances],
                   AllocationOrder.from_dict(order))


class INannyClient(object):
    """
    Interface to be used in dependency injection.
    """
    pass


class NonEmptyList(List):
    def validate(self, obj):
        super(NonEmptyList, self).validate(obj)
        if len(obj) == 0:
            raise InvalidValueError('List is empty')
        return obj


class NannyClient(INannyClient):
    _TESTING_BASE_URL = _PRODUCTION_BASE_URL = 'http://nanny.yandex-team.ru/v2'
    _DEFAULT_REQ_TIMEOUT = 30
    _DEFAULT_ATTEMPTS = 3

    # TODO: at this moment we need only resources and instances section, so we ignore other sections in scheme
    # TODO: ignore_unknown=True is everywhere, need to remove it at some moment

    # we need both required and optional balancing options schemas for
    # sections and backends correspondingly
    REQUIRED_BALANCING_OPTIONS_SCHEMA = DictScheme({
        "backend_timeout": String(),
        "connection_timeout": String(),
        "retries_count": Integer(),
        "fail_on_5xx": Bool(optional=True),
        "keepalive_count": Integer(optional=True),
        "pinger": DictScheme({"url": String()}, optional=True, ignore_unknown=True),
        "balancing_type": DictScheme({
            "mode": String(
                choices=ServiceResources.L7FastBalancerConfigTemplateFile.BALANCING_TYPES),
            "weighted2": Dict(optional=True),
            "rr": DictScheme({}, optional=True),
            "hashing": Dict(optional=True),
        }),
    }, ignore_unknown=True)

    OPTIONAL_BALANCING_OPTIONS_SCHEMA = DictScheme({
        "backend_timeout": String(optional=True),
        "connection_timeout": String(optional=True),
        "retries_count": Integer(optional=True),
        "fail_on_5xx": Bool(optional=True),
        "keepalive_count": Integer(optional=True),
        "pinger": DictScheme({"url": String(optional=True)}, optional=True, ignore_unknown=True),
        "balancing_type": DictScheme({
            "mode": String(
                choices=ServiceResources.L7FastBalancerConfigTemplateFile.BALANCING_TYPES, optional=True),
            "weighted2": Dict(optional=True),
            "rr": DictScheme({}, optional=True),
            "hashing": Dict(optional=True),
        }, optional=True),
    }, optional=True, ignore_unknown=True)

    ADDRESS_SCHEMA = DictScheme({
        "ip": String(optional=True),
        "port": Integer(),
        "use_instance_addr": Bool(optional=True),
        "ssl_enable": Bool(optional=True),
    })

    OPTIONAL_ADDRESS_SCHEMA = DictScheme({
        "ip": String(optional=True),
        "port": Integer(),
        "use_instance_addr": Bool(optional=True),
        "ssl_enable": Bool(optional=True),
    }, optional=True)

    SSL_OPTIONS_SCHEMA = DictScheme({
        'cert': String(optional=True),
        'priv': String(optional=True),
    }, optional=True)

    SERVICES_BALANCER_CONFIG_TEMPLATE_SCHEME = DictScheme({
        "local_path": String(),
        "is_dynamic": Bool(optional=True),
        "download_queue": String(optional=True),
        "content": DictScheme({
            "addr": OPTIONAL_ADDRESS_SCHEMA,  # deprecated
            "admin_addr": OPTIONAL_ADDRESS_SCHEMA,  # deprecated
            "addr_list": List(ADDRESS_SCHEMA),
            "admin_addr_list": List(ADDRESS_SCHEMA),
            "ssl_settings": SSL_OPTIONS_SCHEMA,
            "sections": List(DictScheme(
                {
                    "id": String(),
                    "matcher": DictScheme({
                        "prefix": String(optional=True),
                        "host": String(),
                    }, ignore_unknown=True),
                    "headers": List(DictScheme({
                        "name": String(),
                        "type": String(),
                        "value": String(),
                    }, ignore_unknown=True)),
                    "balancing_options": REQUIRED_BALANCING_OPTIONS_SCHEMA,
                    "traffic_slices": List(DictScheme({
                        "name": String(),
                        "weight": Integer(),
                        "balancing_options": OPTIONAL_BALANCING_OPTIONS_SCHEMA,
                        "backend": DictScheme({
                            "service_id": String(),
                            "snapshot_id": String(),
                        }, ignore_unknown=True),
                    }, ignore_unknown=True)),
                }, ignore_unknown=True)),
            "use_ipv6_only": Bool(optional=True),
        }, ignore_unknown=True)
    }, ignore_unknown=True)

    L7_FAST_BALANCER_GROUP_SCHEME = DictScheme({
        "name": String(),
        "service_id": String(),
        "snapshot_id": String(),
        "balancing_options": OPTIONAL_BALANCING_OPTIONS_SCHEMA,
    }, ignore_unknown=True)

    L7_FAST_BALANCER_TLD_SCHEME = DictScheme({
        "domains": List(String()),
        "groups": List(L7_FAST_BALANCER_GROUP_SCHEME),
    }, ignore_unknown=True)

    L7_FAST_BALANCER_CONFIG_TEMPLATE_SCHEME = DictScheme(
        {
            "local_path": String(),
            "is_dynamic": Bool(optional=True),
            "download_queue": String(optional=True),
            "content": DictScheme({
                "default_port": Integer(optional=True),
                "default_admin_port": Integer(optional=True),
                "main_domain": String(optional=True),
                "secaudited_section_ids": List(String(), optional=True),
                "sections": List(DictScheme(
                    {
                        "id": String(),
                        "prefix": String(),
                        "balancing_options": REQUIRED_BALANCING_OPTIONS_SCHEMA,
                        "https_required": Bool(),
                        "top_level_domains": List(L7_FAST_BALANCER_TLD_SCHEME),
                    }, ignore_unknown=True)),
            }, ignore_unknown=True),
        }, ignore_unknown=True)

    RESOURCES_SECTION_SCHEME = DictScheme(
        {
            "sandbox_bsc_shard": DictScheme(
                {
                    "local_path": String(optional=True),
                    "chosen_type": String(
                        choices=['SANDBOX_SHARD', 'BUNDLE_SHARD', 'REGISTERED_SHARD', 'SANDBOX_SHARDMAP'],
                        optional=True),
                    "resource_type": String(optional=True),
                    "task_id": String(optional=True),
                    "task_type": String(optional=True),
                    "bundle_shard": DictScheme(
                        {
                            'source_resources': List(DictScheme(
                                {
                                    'task_type': String(),
                                    'task_id': String(),
                                    'resource_type': String()
                                }
                            )),
                            'shard_prefix': String(),
                            'resource_type': String(),
                            'release_after_build': Bool(optional=True),
                        }, ignore_unknown=True, optional=True),
                    "registered_shard": DictScheme(
                        {
                            'shard_id': String()
                        }, optional=True),
                    "sandbox_shardmap": DictScheme(
                        {
                            'task_type': String(),
                            'task_id': String(),
                            'resource_type': String()
                        }, optional=True),
                    "download_queue": String(optional=True),
                }, ignore_unknown=True, optional=True),
            "static_files": List(DictScheme(
                {
                    "local_path": String(),
                    "is_dynamic": Bool(optional=True),
                    "download_queue": String(optional=True),
                    "content": String(),
                }, ignore_unknown=True), optional=True),
            "sandbox_files": List(DictScheme(
                {
                    "local_path": String(),
                    "is_dynamic": Bool(optional=True),
                    "download_queue": String(optional=True),
                    "task_id": String(),
                    "task_type": String(),
                    "resource_type": String(),
                }, ignore_unknown=True), optional=True),
            "url_files": List(DictScheme(
                {
                    "local_path": String(),
                    "is_dynamic": Bool(optional=True),
                    "download_queue": String(optional=True),
                    "url": String(),
                }, ignore_unknown=True), optional=True),
            "l7_fast_balancer_config_files": List(L7_FAST_BALANCER_CONFIG_TEMPLATE_SCHEME, optional=True),
            "services_balancer_config_files": List(SERVICES_BALANCER_CONFIG_TEMPLATE_SCHEME, optional=True),
            "template_set_files": List(DictScheme(
                {
                    "local_path": String(),
                    "is_dynamic": Bool(optional=True),
                    "download_queue": String(optional=True),
                    "layout": String(),
                    "templates": List(DictScheme(
                        {
                            "name": String(),
                            "content": String()
                        }
                    ))
                }, ignore_unknown=True), optional=True)
        }, ignore_unknown=True)

    INSTANCES_SECTION_SCHEME = DictScheme(
        {
            "chosen_type": String(
                choices=ServiceInstances.INSTANCE_TYPE_MAPPING.keys()),
            "instance_list": List(DictScheme({
                "host": String(),
                "port": Integer(),
                "tags": List(String(), optional=True),
                "weight": Integer(optional=True),
                "ipv4_address": String(optional=True),
                "ipv6_address": String(optional=True),
            }, ignore_unknown=True), optional=True),
            "gencfg_groups": List(DictScheme({
                "name": String(),
                "release": String(),
                "tags": List(String(), optional=True)
            }, ignore_unknown=True), optional=True),
            "extended_gencfg_groups": DictScheme({
                "tags": List(String(), optional=True),
                "groups": List(DictScheme({
                    "name": String(),
                    "release": String(),
                    "tags": List(String(), optional=True)
                }, ignore_unknown=True), optional=True),
            }, ignore_unknown=True, optional=True),
        }, ignore_unknown=True)

    ENGINES_SECTION_SCHEME = DictScheme(
        {
            'engine_type': String(optional=True)
        },
        ignore_unknown=True,
        optional=True)

    RUNTIME_ATTRIBUTES_SNAPSHOT_SCHEME = DictScheme(
        {
            "_id": String(),
            "service_id": String(),
            "content": DictScheme(
                {
                    "engines": ENGINES_SECTION_SCHEME,
                    "instances": INSTANCES_SECTION_SCHEME,
                    "resources": RESOURCES_SECTION_SCHEME
                },
                ignore_unknown=True)
        },
        ignore_unknown=True)

    ANNOTATED_PORT_SCHEME = DictScheme({
        "port": Integer(),
        "name": String(optional=True),
        "protocol": String(),
    }, ignore_unknown=True)

    ALLOCATION_SCHEME = DictScheme({
        "_id": String(),
        "service_id": String(),
        "instances": List(DictScheme(
            {
                "host": String(),
                "ports": NonEmptyList(ANNOTATED_PORT_SCHEME),
                "weight": Integer(),
                "tags": List(String(), optional=True),
                "ipv4_address": String(optional=True),
                "ipv6_address": String(optional=True),
            }, ignore_unknown=True)),
        "order": DictScheme({
            "cluster": String(),
            "cpu": Integer(),
            "disk": Integer(),
            "memory": Integer(),
        }, ignore_unknown=True),
    }, ignore_unknown=True)

    @classmethod
    def from_config(cls, d):
        return cls(**d)

    def __init__(self, url=None, req_timeout=None, attempts=None, token=None):
        super(NannyClient, self).__init__()
        self._base_url = (url or self._PRODUCTION_BASE_URL).rstrip('/')
        self._req_timeout = req_timeout or self._DEFAULT_REQ_TIMEOUT
        self._attempts = attempts or self._DEFAULT_ATTEMPTS
        self._token = token
        self._session = InstrumentedSession('/clients/nanny')

    def get_runtime_attributes_snapshot(self, service_id, snapshot_id):
        """
        Return info about service runtime attributes (resources, instances, etc)

        :type service_id: str
        :type snapshot_id: str
        :rtype: ServiceRuntimeAttributes
        """
        url = '{base_url}/services/{service_id}/history/runtime_attrs/{snapshot_id}/'.format(
            base_url=self._base_url, service_id=service_id, snapshot_id=snapshot_id
        )
        headers = {}
        if self._token:
            headers = {'Authorization': 'OAuth {}'.format(self._token)}
        with gevent.Timeout(self._req_timeout):
            response = json_request(
                'get', url, scheme=self.RUNTIME_ATTRIBUTES_SNAPSHOT_SCHEME, ok_statuses=[requests.codes.ok],
                exception=NannyApiRequestException, session=self._session, headers=headers
            )
        return ServiceRuntimeAttributes.from_dict(response)

    def get_service_info_attrs(self, service_id):
        url = '{base_url}/services/{service_id}/info_attrs/'.format(base_url=self._base_url,
                                                                    service_id=service_id)
        headers = {}
        if self._token:
            headers = {'Authorization': 'OAuth {}'.format(self._token)}

        with gevent.Timeout(self._req_timeout):
            response = json_request(
                'get', url, ok_statuses=[requests.codes.ok],
                exception=NannyApiRequestException, session=self._session, headers=headers
            )

        return response

    def get_allocation(self, allocation_id):
        """
        Returns allocation.

        :type allocation_id: str
        :rtype: Allocation
        """
        url = '{base_url}/services/allocations/{allocation_id}/'.format(
            base_url=self._base_url, allocation_id=allocation_id
        )
        headers = {}
        if self._token:
            headers['Authorization'] = 'OAuth {}'.format(self._token)
        with gevent.Timeout(self._req_timeout):
            response = json_request(
                'get', url, scheme=self.ALLOCATION_SCHEME, ok_statuses=[requests.codes.ok],
                exception=NannyApiRequestException, session=self._session, headers=headers
            )
        return Allocation.from_dict(response)

    def get_cluster(self, cluster_id):
        """
        Returns allocation cluster description.

        :type cluster_id: str | unicode
        :rtype dict:
        """
        url = '{base_url}/resourcesmanager/clusters/{cluster_id}/'.format(
            base_url=self._base_url, cluster_id=cluster_id
        )
        headers = {}
        if self._token:
            headers['Authorization'] = 'OAuth {}'.format(self._token)
        with gevent.Timeout(self._req_timeout):
            response = json_request(
                'get', url, ok_statuses=[requests.codes.ok], exception=NannyApiRequestException,
                session=self._session, headers=headers
            )
        return response
