import json
from six.moves.urllib.parse import urljoin

import requests
from sepelib.http.session import InstrumentedSession


class ITimelineClient(object):
    """
    Interface to be used in dependency injection.
    """
    pass


class TimelineClient(object):
    TIMELINE_API_URL = 'https://timeline.yandex-team.ru/api/'
    DEFAULT_REQ_TIMEOUT = 10  # seconds

    @classmethod
    def from_config(cls, d):
        return cls(timeline_api_url=d.get('timeline_api_url'),
                   req_timeout=d.get('req_timeout'),
                   verify_ssl=d.get('verify_ssl'))

    def __init__(self, timeline_api_url=None, req_timeout=None, verify_ssl=None):
        self._timeline_api_url = timeline_api_url or self.TIMELINE_API_URL
        self._req_timeout = req_timeout or self.DEFAULT_REQ_TIMEOUT
        self._verify_ssl = True if verify_ssl is None else verify_ssl
        self._session = InstrumentedSession('/clients/timeline')

    def post_event(self, data):
        url = urljoin(self._timeline_api_url, 'event')
        try:
            r = self._session.post(url,
                                   data=json.dumps(data),
                                   headers={'Content-Type': 'application/json'},
                                   verify=self._verify_ssl)
        except requests.exceptions.Timeout:
            raise Exception('request timed out', url)
        r.raise_for_status()
        return r.json()
