import grpc

from . import _auth_plugin
from ._auth_fabric import get_auth_token_requester


class Channels(object):
    def __init__(self, **kwargs):
        self._channel_creds = grpc.ssl_channel_credentials(
            root_certificates=kwargs.get('root_certificates'),
            private_key=kwargs.get('private_key'),
            certificate_chain=kwargs.get('certificate_chain'),
        )
        self._endpoints = {
            "iam": kwargs["iam_endpoint"],
            "dns": kwargs["dns_endpoint"],
        }
        self._token_requester = get_auth_token_requester(token=kwargs.get("token"),
                                                         service_account_key=kwargs.get("service_account_key"))

        self._unauthenticated_channel = None
        self._channels = None

    def channel(self, endpoint):
        if not self._channels:
            plugin = _auth_plugin.Credentials(
                self._token_requester, lambda: self._channels["iam"])
            call_creds = grpc.metadata_call_credentials(plugin)
            creds = grpc.composite_channel_credentials(
                self._channel_creds, call_creds)

            self._channels = {
                id: grpc.secure_channel(address, creds)
                for id, address in self._endpoints.items()
            }

        if endpoint not in self._channels:
            raise RuntimeError('Unknown endpoint: {}'.format(endpoint))

        return self._channels[endpoint]
