package api

import (
	"a.yandex-team.ru/infra/walle/server/go/internal/lib/juggler"
	"a.yandex-team.ru/infra/walle/server/go/internal/lib/monitoring"
	"a.yandex-team.ru/infra/walle/server/go/internal/repos"
	"a.yandex-team.ru/library/go/yandex/unistat"
	"a.yandex-team.ru/library/go/yandex/unistat/aggr"
)

var (
	metrics metricsGroup
)

type metricsGroup struct {
	ResponseTime   *unistat.Histogram
	Requests429    *unistat.Numeric
	Requests4xx    *unistat.Numeric
	Requests5xx    *unistat.Numeric
	Requests2xx    *unistat.Numeric
	FreeAggrBuffer *unistat.Numeric
}

func init() {
	metrics = metricsGroup{
		ResponseTime: unistat.NewHistogram(
			"api.response_time.api.push_health_status",
			0,
			aggr.Histogram(),
			monitoring.TimeBuckets(),
		),
		Requests429:    unistat.NewNumeric("api.status_code.429", 0, aggr.Counter(), unistat.Sum),
		Requests4xx:    unistat.NewNumeric("api.status_code.4xx", 0, aggr.Counter(), unistat.Sum),
		Requests5xx:    unistat.NewNumeric("api.status_code.5xx", 0, aggr.Counter(), unistat.Sum),
		Requests2xx:    unistat.NewNumeric("api.status_code.2xx", 0, aggr.Counter(), unistat.Sum),
		FreeAggrBuffer: unistat.NewNumeric("inner.free_aggr_queue", 0, monitoring.AnnnSuffix(), unistat.Last),
	}
}

func registerMetrics() error {
	return monitoring.RegisterMetrics(metrics, juggler.Metrics, repos.HealthBulkWriterMetrics)
}
