package cron

import (
	"context"
	"fmt"
	"time"

	libcron "a.yandex-team.ru/infra/walle/server/go/internal/lib/cron"
	"a.yandex-team.ru/infra/walle/server/go/internal/lib/monitoring"
	"a.yandex-team.ru/library/go/yandex/unistat"
	"a.yandex-team.ru/library/go/yandex/unistat/aggr"
)

type metricsGroup struct {
	ExecutionTime *unistat.Histogram
}

func newMetricsGroup(jobName string) metricsGroup {
	return metricsGroup{
		ExecutionTime: unistat.NewHistogram(
			fmt.Sprintf("cron.go.%s.execution_time", jobName),
			0,
			aggr.Histogram(),
			monitoring.TimeBucketsLog(),
		),
	}
}

func executionTimeDecorator(metric unistat.Metric) libcron.DecoratorFunc {
	return func(next libcron.JobFunc) libcron.JobFunc {
		return func(ctx context.Context) (bool, error) {
			start := time.Now()
			executed, err := next(ctx)
			if executed {
				monitoring.MeasureSecondsSince(metric, start)
			}
			return executed, err
		}
	}
}
