package screening

import (
	"context"

	"a.yandex-team.ru/infra/walle/server/go/internal/lib/juggler"
	"a.yandex-team.ru/infra/walle/server/go/internal/repos"
)

type ParsedHealthCheck struct {
	rawHealth *juggler.HostCheck
	//TODO
	//juggler.ParsedMetadata
}

type ParsedChecks map[juggler.CheckType]ParsedHealthCheck

func GetHealthState(ctx context.Context, repo *repos.HealthRepo, wr *WorldRequirements) (map[string]ParsedChecks, error) {
	filters := repos.HostCheckFilter{}
	for hostName := range wr.HostsHealth {
		filters.FQDN = append(filters.FQDN, hostName)
	}
	result := make(map[string]ParsedChecks)
	checks, err := repo.Find(ctx, &filters)
	if err != nil {
		return nil, err
	}
	for _, check := range checks {
		if result[check.FQDN] == nil {
			result[check.FQDN] = make(ParsedChecks)
		}
		result[check.FQDN][check.Type] = ParsedHealthCheck{rawHealth: check}
	}
	return result, nil
}
