package screening

import (
	"context"
	"time"

	"a.yandex-team.ru/infra/walle/server/go/internal/repos"
)

type OperationLogState struct {
	//TODO
}

func GetOperationLogState(ctx context.Context, repo *repos.OperationLogRepo, wr *WorldRequirements) (*OperationLogState, error) {
	var result OperationLogState

	//TODO real reqs
	timestamp := time.Now()

	selection, err := repo.Select(
		ctx,
		&repos.OperationLogFilter{Time: timestamp.Add(-10)},
		[]string{repos.AuditLogFieldKeyType, repos.AuditLogFieldKeyProject},
	)

	if err != nil {
		return nil, err
	}
	for selection.Next() {
		var operationTime int64
		var operationType, hostName string
		if err = selection.Scan(&operationTime, &operationType, &hostName); err != nil {
			return nil, err
		}
	}
	return &result, nil
}
