package screening

import (
	"a.yandex-team.ru/infra/walle/server/go/internal/repos"
)

type RepairRuleSelector interface {
	Match(host *repos.Host, state *WorldState) bool
	GetDeps() RuleDependencies
}

type RepairRule struct {
	Enabled   bool
	Name      repos.RepairRuleName
	Selectors []RepairRuleSelector
	Workflow  *RepairWorkflow
}

func (r *RepairRule) Match(host *repos.Host, world *WorldState) bool {
	for _, selector := range r.Selectors {
		if !selector.Match(host, world) {
			return false
		}
	}
	return true
}

func (r *RepairRule) GetDeps() RuleDependencies {
	var result RuleDependencies
	for _, selector := range r.Selectors {
		selectorDeps := selector.GetDeps()
		result.Merge(&selectorDeps)
	}
	return result
}

func HandleHost(host *repos.Host, world *WorldState, rules []RepairRule) *repos.Decision {
	for _, rule := range rules {
		if rule.Match(host, world) {
			if step := rule.Workflow.FindStep(host, world); step != nil {
				decision := (*step).GetDecision(world)
				decision.RuleName = rule.Name
				return decision
			}
		}
	}
	return nil
}

type RulesCache map[repos.ProjectID][]RepairRule

func GetProjectRules(project repos.ProjectID, cache RulesCache) []RepairRule {
	if ret, ok := cache[project]; ok {
		return ret
	}
	//var rules []RepairRule = nil

	// TODO real fill rules map
	cache[project] = makeTestRepairRules()
	return nil
}
