package screening

import (
	"time"

	"a.yandex-team.ru/infra/walle/server/go/internal/repos"
)

type RepairWorkflowStep interface {
	HasCompleted(host *repos.Host, world *WorldState) bool
	GetDecision(world *WorldState) *repos.Decision
}

type RebootStep struct {
	operation   OperationName
	repeatCount uint64
	interval    time.Duration
}

func (s RebootStep) HasCompleted(host *repos.Host, world *WorldState) bool {
	//TODO check operation log here
	return true
}

func (s RebootStep) GetDecision(world *WorldState) *repos.Decision {
	decision := HealthyDecision()
	//TODO fix it
	return &decision
}

type ITDCTicketStep struct {
}

func (s ITDCTicketStep) HasCompleted(host *repos.Host, world *WorldState) bool {
	return false
}

func (s ITDCTicketStep) GetDecision(world *WorldState) *repos.Decision {
	decision := HealthyDecision()
	//TODO fix it
	return &decision
}

type RepairWorkflow struct {
	Steps []RepairWorkflowStep
}

func (rw *RepairWorkflow) FindStep(host *repos.Host, world *WorldState) *RepairWorkflowStep {
	for index, step := range rw.Steps {
		if index == len(rw.Steps)-1 || !step.HasCompleted(host, world) {
			return &step
		}
	}
	return nil
}
