package screening

import (
	"time"

	"a.yandex-team.ru/infra/walle/server/go/internal/repos"

	"a.yandex-team.ru/infra/walle/server/go/internal/lib/juggler"
)

type OperationName string

const (
	RebootOperation = OperationName("reboot")
)

type CheckSelector struct {
	matchedChecks map[juggler.CheckType]juggler.WalleStatus
}

func (s CheckSelector) Match(host *repos.Host, state *WorldState) bool {
	//TODO
	return true
}

func (s CheckSelector) GetDeps() RuleDependencies {
	//TODO
	return RuleDependencies{HostHealth: true}
}

type OperationHistorySelector struct {
	operation OperationName
	interval  time.Duration
	count     int
}

func (s OperationHistorySelector) Match(host *repos.Host, state *WorldState) bool {
	//TODO
	return true
}

func (s OperationHistorySelector) GetDeps() RuleDependencies {
	return RuleDependencies{History: &OperationHistoryDeps{OperationByTypeDeps: map[OperationName]time.Duration{
		s.operation: s.interval,
	}}}
}

type OperationHistoryDeps struct {
	OperationByTypeDeps map[OperationName]time.Duration
}

func (rd *OperationHistoryDeps) Merge(second *OperationHistoryDeps) {
	if second == nil {
		return
	}
	if rd.OperationByTypeDeps == nil {
		rd.OperationByTypeDeps = make(map[OperationName]time.Duration)
	}
	for operation, interval := range second.OperationByTypeDeps {
		firstInterval, found := rd.OperationByTypeDeps[operation]
		if found && firstInterval > interval {
			interval = firstInterval
		}
		rd.OperationByTypeDeps[operation] = interval
	}
}

type RuleDependencies struct {
	HostHealth bool
	History    *OperationHistoryDeps
}

func (rd *RuleDependencies) Merge(second *RuleDependencies) {
	rd.HostHealth = rd.HostHealth || second.HostHealth
	if rd.History == nil {
		rd.History = &OperationHistoryDeps{}
	}
	rd.History.Merge(second.History)
}
