package screening

import (
	"time"

	"a.yandex-team.ru/infra/walle/server/go/internal/lib/juggler"
	"a.yandex-team.ru/infra/walle/server/go/internal/repos"
)

const (
	AvailabilityCheckRuleName = repos.RepairRuleName("AvailabilityCheckRule")
)

func makeSSHRepairRule() RepairRule {
	var selectors []RepairRuleSelector
	var steps []RepairWorkflowStep
	selectors = append(selectors, CheckSelector{matchedChecks: map[juggler.CheckType]juggler.WalleStatus{
		juggler.CheckTypeSSH: juggler.JugglerCrit,
	}})
	steps = append(steps, RebootStep{
		operation:   RebootOperation,
		repeatCount: 3,
		interval:    12 * time.Hour,
	})
	return RepairRule{
		Enabled:   true,
		Name:      AvailabilityCheckRuleName,
		Selectors: selectors,
		Workflow:  &RepairWorkflow{Steps: steps},
	}
}

func makeDeactivateRepairRule() RepairRule {
	var selectors []RepairRuleSelector
	var steps []RepairWorkflowStep
	selectors = append(selectors, OperationHistorySelector{
		operation: RebootOperation,
		interval:  24 * time.Hour,
		count:     10,
	})
	steps = append(steps, RebootStep{repeatCount: 3, interval: 12 * time.Hour})
	return RepairRule{
		Enabled:   true,
		Name:      AvailabilityCheckRuleName,
		Selectors: selectors,
		Workflow:  &RepairWorkflow{Steps: steps},
	}

}

func makeTestRepairRules() []RepairRule {
	var rules []RepairRule
	rules = append(rules, makeSSHRepairRule())
	rules = append(rules, makeDeactivateRepairRule())
	return rules
}
