package screening

import (
	"context"
	"time"

	"a.yandex-team.ru/infra/walle/server/go/internal/repos"
)

type void struct{}
type HostsHealthRequirements map[repos.HostName]void

type HostOperationLogRequirements struct {
	Host      repos.HostName
	Operation OperationName
	Interval  time.Duration
}

type WorldRequirements struct {
	HostsHealth  HostsHealthRequirements
	OperationLog []HostOperationLogRequirements
}

func (wr *WorldRequirements) Add(host *repos.Host, deps RuleDependencies) {
	if deps.HostHealth {
		if wr.HostsHealth == nil {
			wr.HostsHealth = make(HostsHealthRequirements)
		}
		wr.HostsHealth[host.Name] = void{}
	}
	if deps.History != nil {
		for operation, interval := range deps.History.OperationByTypeDeps {
			wr.OperationLog = append(wr.OperationLog, HostOperationLogRequirements{
				Host:      host.Name,
				Operation: operation,
				Interval:  interval,
			})
		}
	}
}

func (wr *WorldRequirements) GetWorldState(
	ctx context.Context,
	healthRepo *repos.HealthRepo,
	operationLogRepo *repos.OperationLogRepo,
) (*WorldState, error) {
	//TODO two goroutine
	health, err := GetHealthState(ctx, healthRepo, wr)
	if err != nil {
		return nil, err
	}
	operationLogState, err := GetOperationLogState(ctx, operationLogRepo, wr)
	if err != nil {
		return nil, err
	}
	return &WorldState{
		hosts:        health,
		operationLog: operationLogState,
	}, nil
}

type WorldState struct {
	hosts        map[string]ParsedChecks
	operationLog *OperationLogState
}
