package automation

type HostOperationStatus string

type Operation struct {
	Metric string
}

var Operations = map[HostOperationStatus]*Operation{
	"adding": {
		Metric: "host-addition",
	},
	"deleting": {
		Metric: "host-deletion",
	},
	"rebooting": {
		Metric: "reboot",
	},
	"profiling": {
		Metric: "profile",
	},
	"deploying": {
		Metric: "redeploy",
	},
	"repairing": {
		Metric: "hardware-repair",
	},
	"reporting-failure": {
		Metric: "failure-reports",
	},
	"repairing-rack": {
		Metric: "rack-repairs",
	},
	"repairing-rack-overheat": {
		Metric: "rack-overheat-repairs",
	},
	"repairing-link": {
		Metric: "link-repair",
	},
	"repairing-bmc": {
		Metric: "bmc-repair",
	},
	"resetting-bmc": {
		Metric: "bmc-reset",
	},
	"changing-memory": {
		Metric: "memory-changes",
	},
	"changing-disk": {
		Metric: "disk-changes",
	},
	"replacing-disk-cable": {
		Metric: "disk-cable-replacements",
	},
	"repairing-cpu": {
		Metric: "cpu-repairs",
	},
	"repairing-gpu": {
		Metric: "gpu-repairs",
	},
	"repairing-ib-link": {
		Metric: "ib-link-repair",
	},
	"repairing-infiniband": {
		Metric: "infiniband-repairs",
	},
	"repairing-memory": {
		Metric: "memory-repairs",
	},
	"repairing-overheat": {
		Metric: "cpu-overheat-repair",
	},
	"repairing-capping": {
		Metric: "cpu-capping-repairs",
	},
	"repairing-reboots": {
		Metric: "reboots-repairs",
	},
	"switching-to-maintenance": {},
	"switching-to-assigned":    {},
	"deactivating":             {},
	"preparing": {
		Metric: "prepare",
	},
	"powering-on": {
		Metric: "power-on",
	},
	"powering-off": {
		Metric: "power-off",
	},
	"checking-dns": {
		Metric: "dns-check",
	},
	"switching-vlans": {
		Metric: "vlan-switch",
	},
	"switching-project": {
		Metric: "project-switching",
	},
	"releasing-host": {
		Metric: "release-host",
	},
	"fqdn-deinvalidating": {
		Metric: "fqdn-deinvalidation",
	},
	"syncing-bot-project":      {},
	"waiting-host-acquirement": {},
	"report-2nd-time-node": {
		Metric: "2nd-time-node",
	},
	"pushing-cauth-settings": {
		Metric: "cauth-settings-pushes",
	},
}
