package client

import (
	"net/http"
	"net/http/httptest"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"

	netutil "a.yandex-team.ru/infra/walle/server/go/internal/lib/net"
)

func TestRacktablesGetSwitchPorts(t *testing.T) {
	table := "switch_name\tport_1\tmock\n" +
		"switch_name\tport_2\tmock\n" +
		"switch_name\tbad_line\n" +
		"switch_name\tbad_line\tbad_line\tbad_line\n" +
		"switch_name_other\tport_other\tmock\n"
	rtServer := httptest.NewServer(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		_, err := w.Write([]byte(table))
		assert.NoError(t, err)
	}))
	rtClient := &racktables{client: &http.Client{}, host: rtServer.URL}
	res, err := rtClient.getSwitchPorts()
	require.NoError(t, err)
	expected := map[netutil.SwitchName][]netutil.SwitchPort{
		"switch_name":       {"port_1", "port_2"},
		"switch_name_other": {"port_other"},
	}
	require.Equal(t, expected, res)
}
