package collections

type ChunkIndexes struct {
	From, To int
}

func SplitIntoChunks(length int, chunkSize int) []ChunkIndexes {
	if chunkSize == 0 && length == 0 {
		return nil
	}
	out := make([]ChunkIndexes, 0, (length+chunkSize-1)/chunkSize)
	for i := 0; i < length; i += chunkSize {
		end := i + chunkSize
		if end > length {
			end = length
		}
		out = append(out, ChunkIndexes{i, end})
	}
	return out
}
