package collections

import "math"

func Map[I any, O any](items []I, f func(I) O) []O {
	result := make([]O, 0, len(items))
	for _, item := range items {
		result = append(result, f(item))
	}
	return result
}

func Chunks[I any](items []I, size int) [][]I {
	if len(items) == 0 {
		return nil
	}
	length := len(items)
	chunkCount := int(math.Ceil(float64(length) / float64(size)))
	result := make([][]I, 0, chunkCount)
	for i := 0; i < chunkCount; i++ {
		start := i * size
		end := (i + 1) * size
		if end > length {
			end = length
		}
		result = append(result, items[start:end])
	}
	return result
}
