package collections

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestChunks1(t *testing.T) {
	input := [...]int{0, 1, 2, 3}
	result := Chunks(input[:], 2)
	assert.Equal(t, len(result), 2)
	oracleFirstChink := [...]int{0, 1}
	oracleSecondChunk := [...]int{2, 3}
	assert.Equal(t, result[0], oracleFirstChink[:])
	assert.Equal(t, result[1], oracleSecondChunk[:])
}

func TestChunks2(t *testing.T) {
	input := [...]int{0, 1, 2}
	result := Chunks(input[:], 2)
	assert.Equal(t, len(result), 2)
	oracleFirstChink := [...]int{0, 1}
	oracleSecondChunk := [...]int{2}
	assert.Equal(t, result[0], oracleFirstChink[:])
	assert.Equal(t, result[1], oracleSecondChunk[:])
}

func TestChunksEmpty(t *testing.T) {
	input := [...]int{}
	result := Chunks(input[:], 2)
	assert.Equal(t, len(result), 0)
}

func TestMap1(t *testing.T) {
	input := [...]int{0, 1, 2}
	result := Map(input[:], func(i int) int { return i + 1 })
	oracleSecondChunk := [...]int{1, 2, 3}
	assert.Equal(t, result, oracleSecondChunk[:])
}

func TestMapEmpty(t *testing.T) {
	input := [...]int{}
	result := Map(input[:], func(i int) int { return i + 1 })
	assert.Equal(t, len(result), 0)
}
