package lib

import (
	"fmt"
	"os"
	"regexp"

	"gopkg.in/yaml.v2"
)

func LoadConfig(path string, container interface{}) error {
	data, err := os.ReadFile(path)
	if err != nil {
		return err
	}
	if err = yaml.Unmarshal(data, container); err != nil {
		return err
	}
	if data, err = yaml.Marshal(container); err != nil {
		return err
	}
	data, err = substituteEnv(data)
	if err != nil {
		return err
	}
	return yaml.Unmarshal(data, container)
}

var optionalEnvVariables = map[string]bool{"WALLE_TIER": true}

func substituteEnv(data []byte) ([]byte, error) {
	re := regexp.MustCompile(`{{([\w-])+}}`)
	var err error
	return re.ReplaceAllFunc(data, func(match []byte) []byte {
		match = match[2 : len(match)-2]
		varName := string(match)
		val := os.Getenv(varName)
		if val == "" {
			_, ignore := optionalEnvVariables[varName]
			if !ignore {
				err = fmt.Errorf("%s not set", string(match))
			}
		}
		return []byte(val)
	}), err
}
