package lib

import (
	"fmt"
	"os"
	"testing"

	"github.com/stretchr/testify/require"
)

func TestSubstituteEnv(t *testing.T) {
	template := "foo %s bar %s text %s"
	envKey1 := "TEST_ENV_Ab3-"
	envKey2 := "TEST_ENV_2"
	moustache := func(s string) string { return fmt.Sprintf("{{%s}}", s) }
	source := fmt.Sprintf(template, moustache(envKey1), moustache(envKey2), moustache(envKey1))
	_, err := substituteEnv([]byte(source))
	require.Error(t, err)
	envVal1 := "val1"
	envVal2 := "val2"
	_ = os.Setenv(envKey1, envVal1)
	_ = os.Setenv(envKey2, envVal2)
	expected := fmt.Sprintf(template, envVal1, envVal2, envVal1)
	result, err := substituteEnv([]byte(source))
	require.NoError(t, err)
	require.Equal(t, expected, string(result))
}
