package cron

import (
	"context"

	"go.mongodb.org/mongo-driver/mongo"
	"go.mongodb.org/mongo-driver/mongo/readpref"

	"a.yandex-team.ru/infra/walle/server/go/internal/lib"
	"a.yandex-team.ru/infra/walle/server/go/internal/lib/db"
	"a.yandex-team.ru/infra/walle/server/go/internal/lib/httputil"
	"a.yandex-team.ru/infra/walle/server/go/internal/lib/monitoring"
	"a.yandex-team.ru/library/go/core/log"
)

type Config struct {
	BaseApp      lib.AppConfig                 `yaml:",inline"`
	HTTPServer   httputil.ServerConfig         `yaml:"http_server"`
	Mongo        db.MongoConfig                `yaml:"mongo"`
	MongoHealth  db.MongoConfig                `yaml:"mongo_health"`
	YDB          db.YDBConfig                  `yaml:"ydb"`
	JugglerAgent monitoring.JugglerAgentConfig `yaml:"juggler_agent"`
	Registry     RegistryConfig                `yaml:"cron"`
	ExpertSystem *lib.ExpertSystemConfig       `yaml:"expert_system"`
}

type RegistryConfig struct {
	Jobs map[string]jobConfig `yaml:"jobs"`
}

type jobMonitoringConfig struct {
	CritTimeout string `yaml:"crit_timeout"`
}

type jobConfig struct {
	Spec       *Spec                  `yaml:"spec"`
	Monitoring *jobMonitoringConfig   `yaml:"monitoring,omitempty"`
	Extra      map[string]interface{} `yaml:"extra,omitempty"`
}

type Store struct {
	YDB                 *db.YDBClient
	MongoDB             *mongo.Database
	MongoDBHealth       *mongo.Database
	MongoReadPref       *readpref.ReadPref
	MongoReadPrefHealth *readpref.ReadPref
}

func NewStore(
	ydb *db.YDBClient,
	mongoDB *mongo.Database,
	mongoDBHealth *mongo.Database,
	readPref *readpref.ReadPref,
	readPrefHealth *readpref.ReadPref,
) *Store {
	return &Store{
		YDB:                 ydb,
		MongoDB:             mongoDB,
		MongoDBHealth:       mongoDBHealth,
		MongoReadPref:       readPref,
		MongoReadPrefHealth: readPrefHealth,
	}
}

type JobConfig struct {
	Store        *Store
	Logger       log.Logger
	Extra        map[string]interface{}
	GlobalConfig *Config
}

type NewJob func(*JobConfig) (Job, error)

type Job interface {
	Do(ctx context.Context) (bool, error)
}

type JobFunc func(ctx context.Context) (bool, error)
type DecoratorFunc func(next JobFunc) JobFunc
