package cron

import (
	"context"
	"fmt"
	"sync"
	"testing"

	"github.com/stretchr/testify/suite"
)

type SchedulerSuite struct {
	suite.Suite
	scheduler *Scheduler
	results   chan int
}

func (suite *SchedulerSuite) SetupSuite() {
	ctx, cancel := context.WithCancel(context.Background())
	suite.scheduler = &Scheduler{ctx: ctx, cancelFunc: cancel, wg: &sync.WaitGroup{}}
	suite.results = make(chan int, 1)
	factory := func(n int) JobFunc {
		return func(ctx context.Context) (bool, error) {
			select {
			case suite.results <- n:
			case <-ctx.Done():
			}
			return true, nil
		}
	}
	for i := 0; i < 2; i++ {
		err := suite.scheduler.Add("name", &Spec{Every: fmt.Sprintf("%ds", i+1)}, factory(i))
		suite.Require().NoError(err)
	}
}

func (suite *SchedulerSuite) TestRun() {
	suite.scheduler.Start()
	var i, zeros, ones int
	for r := range suite.results {
		switch r {
		case 0:
			zeros++
		case 1:
			ones++
		}
		i++
		if i == 3 {
			suite.scheduler.Stop()
			break
		}
	}
	suite.Equal(2, zeros/ones)
}

func TestScheduler(t *testing.T) {
	suite.Run(t, new(SchedulerSuite))
}
