package db

import (
	"context"
	"fmt"
	"os"
	"testing"
	"time"

	"go.mongodb.org/mongo-driver/bson"
	"go.mongodb.org/mongo-driver/mongo"
	"go.mongodb.org/mongo-driver/mongo/options"
)

func TestNewMongoConnect(t *testing.T) {
	port := os.Getenv("RECIPE_MONGO_PORT")
	cnf := MongoConfig{
		Hosts:    []string{fmt.Sprintf("localhost:%s", port)},
		Database: "test",
		Username: "test",
		Password: "test",
	}
	ctx, cancel := context.WithTimeout(context.Background(), 5*time.Second)
	defer cancel()
	opts := options.Client().
		SetHosts(cnf.Hosts)
	client, err := mongo.Connect(ctx, opts)
	if err != nil {
		t.Errorf("fatal: %v", err)
		return
	}
	defer func() {
		_ = client.Disconnect(ctx)
	}()
	result := client.
		Database(cnf.Database).
		RunCommand(ctx, bson.D{
			{Key: "createUser", Value: cnf.Username},
			{Key: "pwd", Value: cnf.Password},
			{Key: "roles", Value: []bson.M{}},
		})
	if err = result.Err(); err != nil {
		t.Errorf("fatal: %v", err)
		return
	}
	db, err := NewMongoConnect(ctx, cnf)
	defer func() {
		if db != nil {
			_ = db.Client().Disconnect(ctx)
		}
	}()
	if err != nil {
		t.Errorf("expected no error, got: %v", err)
		return
	}
}
