package juggler

import (
	"testing"

	"github.com/stretchr/testify/require"
)

func TestHwWatcherEffectiveTimestamp(t *testing.T) {
	child := JugglerChild{
		ServiceName: CheckTypeDisk,
		Actual: JugglerChildActual{
			Metadata: `{"result": {"status": "OK", "timestamp": 1621935450.575626, "reason": ["Last check: Tue May 25 12:37:30 2021"]}}`,
		},
	}
	_, err := calculateEffectiveTimestamp(child, WalleCheckStatusPassed, 1621935050, 1621935400)
	require.Equal(t, nil, err)
}

func TestCustomPassiveEffectiveTimestamp(t *testing.T) {
	child := JugglerChild{
		ServiceName: CheckTypeClocksource,
		Actual: JugglerChildActual{
			Metadata: `{"status": "OK", "timestamp": 1621935700.149078, "reason": "Last check: Tue May 25 12:41:40 2021"}`,
		},
	}
	_, err := calculateEffectiveTimestamp(child, WalleCheckStatusPassed, 1621935050, 1621935400)
	require.Equal(t, nil, err)
}

func TestBmcFirstFormatEffectiveTimestamp(t *testing.T) {
	child := JugglerChild{
		ServiceName: CheckTypeBmc,
		Actual: JugglerChildActual{
			Metadata: `{"status": "OK", "timestamp": "1622022713.91", "reason": "[u'Last check: Wed May 26 12:51:53 2021']"}`,
		},
	}
	_, err := calculateEffectiveTimestamp(child, WalleCheckStatusPassed, 1621935050, 1621935400)
	require.Equal(t, nil, err)
}

func TestBmcSecondFormatEffectiveTimestamp(t *testing.T) {
	child := JugglerChild{
		ServiceName: CheckTypeBmc,
		Actual: JugglerChildActual{
			Metadata: `{"result": {"status": "OK", "timestamp": 1622101008.686629, "reason": ["Last check: Thu May 27 10:36:48 2021"]}}`,
		},
	}
	_, err := calculateEffectiveTimestamp(child, WalleCheckStatusPassed, 1621935050, 1621935400)
	require.Equal(t, nil, err)
}

func TestMemoryEffectiveTimestamp(t *testing.T) {
	child := JugglerChild{
		ServiceName: CheckTypeMemory,
		Actual: JugglerChildActual{
			Metadata: `{"results": {"mem": {"status": "OK", "timestamp": 1621948306.314043, "reason": ["Last check: Tue May 25 16:11:46 2021"]}, "ecc": {"status": "OK", "timestamp": 1621947705.46675, "reason": ["Last check: Tue May 25 16:01:45 2021"]}}}`,
		},
	}
	_, err := calculateEffectiveTimestamp(child, WalleCheckStatusPassed, 1621935050, 1621935400)
	require.Equal(t, nil, err)
}

func TestWalleBasedEffectiveTimestamp(t *testing.T) {
	child := JugglerChild{
		ServiceName: CheckTypeRackOverheat,
		Actual: JugglerChildActual{
			Metadata: `{"total":11,"suspected":0,"failed":0,"threshold_flapping":0,"threshold_failed":50,"last_crit":0,"suspected_timeout":1200}`,
		},
	}
	_, err := calculateEffectiveTimestamp(child, WalleCheckStatusPassed, 1621935050, 1621935400)
	require.Equal(t, nil, err)
}
