package juggler

import (
	"a.yandex-team.ru/library/go/yandex/unistat"
	"a.yandex-team.ru/library/go/yandex/unistat/aggr"
)

var (
	Metrics metricsGroup
)

type metricsGroup struct {
	BatchAggrCount   *unistat.Numeric
	BatchChecksCount *unistat.Numeric
	ReceivedEvents   *unistat.Numeric
	ChangedEvents    *unistat.Numeric
}

func init() {
	Metrics = metricsGroup{
		ChangedEvents:    unistat.NewNumeric("db.check_storing.changed", 0, aggr.Counter(), unistat.Sum),
		BatchAggrCount:   unistat.NewNumeric("juggler.batch.aggr.count", 0, aggr.Counter(), unistat.Sum),
		ReceivedEvents:   unistat.NewNumeric("juggler.check_storing.received", 0, aggr.Counter(), unistat.Sum),
		BatchChecksCount: unistat.NewNumeric("juggler.batch.checks.count", 0, aggr.Counter(), unistat.Sum),
	}
}
