package monitoring

import (
	"fmt"
	"net/http"

	"github.com/labstack/echo/v4"

	"a.yandex-team.ru/library/go/yandex/unistat"
)

var defaultRegistry = unistat.NewRegistry()

func RegisterMetrics(metricGroups ...interface{}) error {
	for _, g := range metricGroups {
		metrics, err := getMetricSliceFromStruct(g)
		if err != nil {
			return err
		}
		for _, m := range metrics {
			defaultRegistry.Register(m)
		}
	}
	return nil
}

func NewUnistatHTTPHandler() echo.HandlerFunc {
	return func(ctx echo.Context) error {
		bytes, err := defaultRegistry.MarshalJSON()
		if err != nil {
			return ctx.String(
				http.StatusInternalServerError,
				fmt.Sprintf("marshal metrics to json: %v", err),
			)
		}
		return ctx.Blob(http.StatusOK, echo.MIMEApplicationJSON, bytes)
	}
}
