package monitoring

import (
	"testing"

	"github.com/stretchr/testify/require"

	"a.yandex-team.ru/library/go/yandex/unistat"
	"a.yandex-team.ru/library/go/yandex/unistat/aggr"
)

func TestRegisterMetrics(t *testing.T) {
	type A struct {
		Numeric *unistat.Numeric
		Hist    *unistat.Histogram
	}
	type B struct {
		Numeric *unistat.Numeric
		Hist    *unistat.Histogram
	}
	a := A{
		Numeric: unistat.NewNumeric("numeric-a", 0, aggr.Counter(), unistat.Sum),
		Hist:    unistat.NewHistogram("hist-a", 0, aggr.Counter(), []float64{1, 1, 1}),
	}
	b := B{
		Numeric: unistat.NewNumeric("numeric-b", 0, aggr.Counter(), unistat.Sum),
		Hist:    unistat.NewHistogram("hist-b", 0, aggr.Counter(), []float64{1, 1, 1}),
	}
	require.NoError(t, RegisterMetrics(a, b))
}
