package netutil

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestIsValidFQDN(t *testing.T) {
	assert.Equal(t, true, IsValidFQDN("host.fqdn"))
	assert.Equal(t, true, IsValidFQDN("abc-1.abc-2.abc"))
	assert.Equal(t, false, IsValidFQDN("abc-1.abc-.abc"))
	assert.Equal(t, false, IsValidFQDN("abc-1.abc.ab1"))
}
func TestShortenRacktablesPortName(t *testing.T) {
	cases := map[SwitchPort]SwitchPort{
		"eth-Trunk1":              "eth-trunk1",
		"Eth1/01":                 "e1/01",
		"FastEthernet 2/02/8":     "fa2/02/8",
		"GigabitEthernet 2/2":     "gi2/2",
		"TenGigabitEthernet01/01": "te01/01",
		"XGigabitEthernet01/01":   "xg01/01",
		"LongReachEthernet2/34":   "lo2/34",
		"ManagementEthernet1/5/4": "ma1/5/4",
		"Mg3/m1":                  "mg3/m1",
	}
	for port, shortName := range cases {
		assert.Equal(t, shortName, ShortenRacktablesPortName(port))
	}
}
