package metrics

import (
	"testing"

	"github.com/stretchr/testify/suite"

	"a.yandex-team.ru/infra/walle/server/go/internal/repos"
)

type DataSuite struct {
	suite.Suite
}

func (suite *DataSuite) TestDataComputeExpertiseAgeQuantiles() {
	data := &data{
		ShardExpertises: []*shardExpertise{
			{shard: &shard{id: 0, tier: 1}, age: 100},
			{shard: &shard{id: 0, tier: 2}, age: 100},
			{shard: &shard{id: 2, tier: 1}, age: 120},
			{shard: &shard{id: 1, tier: 1}, age: 150},
		},
		Hosts: &hosts{
			Num: 10,
			Shards: &hostShards{
				DistributionByProjects: map[repos.ProjectID]map[shard]int{
					"project-1": {{id: 0, tier: 1}: 2, {id: 2, tier: 1}: 2},
					"project-2": {{id: 1, tier: 1}: 4},
					"project-3": {{id: 0, tier: 2}: 2},
				},
				NumberByProjects: map[repos.ProjectID]int{
					"project-1": 4,
					"project-2": 4,
					"project-3": 2,
				},
				TotalDistribution: map[shard]int{
					{id: 0, tier: 1}: 2,
					{id: 0, tier: 2}: 2,
					{id: 1, tier: 1}: 4,
					{id: 2, tier: 1}: 2,
				},
			},
		},
	}
	data.computeExpertiseAgeQuantiles()
	expected := quantiles{
		total: map[float64]int64{0.01: 100, 0.75: 150, 0.99: 150},
		byProjects: map[repos.ProjectID]map[float64]int64{
			"project-1": {0.01: 100, 0.75: 120, 0.99: 120},
			"project-2": {0.01: 150, 0.75: 150, 0.99: 150},
			"project-3": {0.01: 100, 0.75: 100, 0.99: 100},
		},
		byTiers: make(map[int]map[float64]int64),
	}
	suite.Require().Equal(expected, data.ExpertiseAgeQuantiles)
}

func TestData(t *testing.T) {
	suite.Run(t, new(DataSuite))
}
