package metrics

import (
	"context"

	"a.yandex-team.ru/infra/walle/server/go/internal/lib/db"
	"a.yandex-team.ru/infra/walle/server/go/internal/repos"
)

type HealthRepo interface {
	AggregateMetrics(ctx context.Context, buckets []float64) (*repos.HealthMetricAggregation, error)
}

type MetricRepo interface {
	Update(ctx context.Context, group *repos.MetricGroup) error
}

type HostRepo interface {
	Select(ctx context.Context, filter *repos.HostFilter, keys []string) (*db.MongoSelection, error)
}

type ProjectRepo interface {
	FindFieldValues(ctx context.Context, filter *repos.ProjectFilter, fieldKey string) ([]string, error)
}

type ShardRepo interface {
	Find(ctx context.Context, filter *repos.ShardFilter) ([]*repos.Shard, error)
}

type ErrorReportRepo interface {
	Select(ctx context.Context, filter *repos.ErrorReportFilter, keys []string) (*db.MongoSelection, error)
}

type AuditLogRepo interface {
	Select(ctx context.Context, filter *repos.AuditLogFilter, keys []string) (*db.MongoSelection, error)
}

type AutomationPlotRepo interface {
	ListAllChecks(ctx context.Context) ([]string, error)
}
