package repos

import (
	"context"

	"go.mongodb.org/mongo-driver/bson"
	"go.mongodb.org/mongo-driver/mongo"
	"go.mongodb.org/mongo-driver/mongo/options"
	"go.mongodb.org/mongo-driver/mongo/readpref"

	"a.yandex-team.ru/infra/walle/server/go/internal/lib/db"
)

const errorReportCollectionName = "error_reports"

const (
	ErrorReportFieldKeyID     = "_id"
	ErrorReportFieldKeyHosts  = "hosts"
	ErrorReportFieldKeyClosed = "closed"
)

type ErrorReport struct {
	ID     string             `bson:"_id"`
	Hosts  []*ErrorReportHost `bson:"hosts"`
	Closed bool               `bson:"closed"`
}

type ErrorReportHost struct {
	Project ProjectID `bson:"project"`
	Solved  bool      `bson:"solved"`
}

type ErrorReportRepo struct {
	collection *mongo.Collection
}

func NewErrorReportRepo(db *mongo.Database, pref *readpref.ReadPref) *ErrorReportRepo {
	return &ErrorReportRepo{
		collection: db.Collection(errorReportCollectionName, options.Collection().SetReadPreference(pref)),
	}
}

func (repo *ErrorReportRepo) Select(ctx context.Context, filter *ErrorReportFilter, keys []string) (*db.MongoSelection, error) {
	filters := bson.D{}
	if filter != nil {
		filters = filter.getBSON()
	}
	return db.NewMongoSelection(ctx, repo.collection, filters, options.Find(), keys)
}

type ErrorReportFilter struct {
	Open bool
}

func (f *ErrorReportFilter) getBSON() bson.D {
	filters := bson.D{}
	if f.Open {
		filters = append(filters, bson.E{Key: ErrorReportFieldKeyClosed, Value: bson.M{"$ne": true}})
	}
	return filters
}
