package repos

import (
	"strings"
	"unsafe"

	"go.mongodb.org/mongo-driver/mongo"
	"go.mongodb.org/mongo-driver/mongo/options"
	"go.mongodb.org/mongo-driver/mongo/readpref"

	"a.yandex-team.ru/infra/walle/server/go/internal/lib/db"
	netutil "a.yandex-team.ru/infra/walle/server/go/internal/lib/net"
)

const hostMacsCollectionName = "host_macs"

const (
	HostMacsFieldKeyID        = "_id"
	HostMacsFieldKeyFirstTime = "first_time"
	HostMacsFieldKeyLastTime  = "last_time"
	HostMacsFieldKeyMacs      = "macs"
	HostMacsFieldKeyName      = "name"
)

type HostMacs struct {
	ID        string        `bson:"_id"`
	FirstTime int64         `bson:"first_time"`
	LastTime  int64         `bson:"last_time"`
	MACs      []netutil.MAC `bson:"macs"`
	Name      string        `bson:"name"`
}

type HostMacsRepo struct {
	collection *mongo.Collection
}

func NewHostMacsRepo(db *mongo.Database, pref *readpref.ReadPref) *HostMacsRepo {
	return &HostMacsRepo{
		collection: db.Collection(hostMacsCollectionName, options.Collection().SetReadPreference(pref)),
	}
}

func (repo *HostNetworkRepo) NewBulkWriter(opts *db.MongoBulkWriterOptions) (db.BulkWriter, error) {
	return db.NewMongoBulkWriter(repo.collection, opts)
}

func init() {
	_ = netutil.MAC("")
}

func NewHostMacsID(hostName string, macs []netutil.MAC) string {
	str := *(*[]string)(unsafe.Pointer(&macs))
	return hostName + ":" + strings.Join(str, "|")
}
