package repos

import (
	"a.yandex-team.ru/infra/walle/server/go/internal/lib/monitoring"
	"a.yandex-team.ru/library/go/yandex/unistat"
	"a.yandex-team.ru/library/go/yandex/unistat/aggr"
)

var (
	HealthBulkWriterMetrics healthBulkWriterMetricsGroup
)

type healthBulkWriterMetricsGroup struct {
	FlushTime      *unistat.Histogram
	UpsertedChecks *unistat.Numeric
	ModifiedChecks *unistat.Numeric
	FreeBuffer     *unistat.Numeric
}

func init() {
	HealthBulkWriterMetrics = healthBulkWriterMetricsGroup{
		FlushTime: unistat.NewHistogram(
			"db.check_storing.db_flush_time",
			0,
			aggr.Histogram(),
			monitoring.TimeBuckets(),
		),
		UpsertedChecks: unistat.NewNumeric("db.check_storing.upserted", 0, aggr.Counter(), unistat.Sum),
		ModifiedChecks: unistat.NewNumeric("db.check_storing.modified", 0, aggr.Counter(), unistat.Sum),
		FreeBuffer:     unistat.NewNumeric("inner.free_check_buffer", 0, monitoring.AnnnSuffix(), unistat.Last),
	}
}
