package repos

import (
	"context"
	"time"

	"a.yandex-team.ru/infra/walle/server/go/internal/lib/db"

	"go.mongodb.org/mongo-driver/bson"
	"go.mongodb.org/mongo-driver/mongo"
	"go.mongodb.org/mongo-driver/mongo/options"
	"go.mongodb.org/mongo-driver/mongo/readpref"
)

const operationLogCollectionName = "operation_log"

const (
	OperationLogFieldKeyTime     = "time"
	OperationLogFieldKeyType     = "type"
	OperationLogFieldKeyHostName = "host_name"
)

type OperationLogRepo struct {
	collection *mongo.Collection
}

func NewOperationLogRepo(db *mongo.Database, pref *readpref.ReadPref) *OperationLogRepo {
	return &OperationLogRepo{
		collection: db.Collection(operationLogCollectionName, options.Collection().SetReadPreference(pref)),
	}
}

func (repo *OperationLogRepo) Select(ctx context.Context, filter *OperationLogFilter, keys []string) (*db.MongoSelection, error) {
	filters := bson.D{}
	if filter != nil {
		filters = filter.getBSON()
	}
	return db.NewMongoSelection(ctx, repo.collection, filters, options.Find(), keys)
}

type OperationLogFilter struct {
	Time time.Time
}

func (f *OperationLogFilter) getBSON() bson.D {
	filters := bson.D{}
	if !f.Time.IsZero() {
		filters = append(filters, bson.E{Key: OperationLogFieldKeyTime, Value: bson.M{"$gt": f.Time.Unix()}})
	}
	return filters
}
