package job

import (
	"context"
	"time"

	"a.yandex-team.ru/infra/walle/server/go/internal/repos"
)

type ProjectRepo interface {
	FindCommon(ctx context.Context, filter *repos.ProjectFilter) ([]*repos.ProjectCommon, error)
	FindFieldValues(ctx context.Context, filter *repos.ProjectFilter, fieldKey string) ([]string, error)
}

type HostRepo interface {
	FindCommon(ctx context.Context, filters *repos.HostFilter) ([]*repos.HostCommon, error)
}

type StatRepo interface {
	InsertProjectTagSnapshots(ctx context.Context, snapshots []*repos.ProjectTagSnapshot) error
	InsertHostProjectSnapshots(ctx context.Context, snapshots []*repos.HostProjectSnapshot) error
	FindHostStateEvents(
		ctx context.Context,
		fqdn repos.HostName,
		notEarlier time.Time,
		notLater time.Time,
	) ([]*repos.HostStateEvent, error)
	InsertHostStateEvents(ctx context.Context, events []*repos.HostStateEvent) error
	FindLastHostStateSnapshot(ctx context.Context, fqdn repos.HostName) (time.Time, error)
	FindHostStateSnapshots(ctx context.Context,
		fqdn repos.HostName,
		notEarlier time.Time,
		notLater time.Time,
	) ([]*repos.HostStateSnapshot, error)
	InsertHostStateSnapshots(ctx context.Context, snapshots []*repos.HostStateSnapshot) error
}
