package repository

import (
	"context"
	"os"
	"sync"
	"testing"
	"time"

	"github.com/gofrs/uuid"
	"github.com/stretchr/testify/suite"

	"a.yandex-team.ru/infra/walle/server/go/internal/lib/db"
)

type LocksRepoTestSuite struct {
	suite.Suite
	repo   LockRepo
	client *db.YDBClient
}

func (suite *LocksRepoTestSuite) SetupSuite() {
	conf := db.YDBConfig{
		Endpoint: os.Getenv("YDB_ENDPOINT"),
		Database: os.Getenv("YDB_DATABASE"),
		Token:    "token",
	}
	ctx := context.Background()
	var err error
	suite.client, err = db.NewYDBClient(ctx, conf)
	suite.NoError(err)
	suite.repo = NewLockRepository(suite.client)
	query, err := os.ReadFile(os.Getenv("ARCADIA_SOURCE_ROOT") + "/infra/walle/server/go/migrations/2021-08-27-001-locks.sql")
	suite.NoError(err)
	session, err := suite.client.CreateSession(ctx)
	suite.NoError(err)
	suite.NoError(session.ExecuteSchemeQuery(ctx, string(query)))
}

func (suite *LocksRepoTestSuite) TearDownSuite() {
	_ = suite.client.Close()
}

func (suite *LocksRepoTestSuite) TestTryLock() {

	size := 10
	results := make([]bool, size)
	wg := &sync.WaitGroup{}
	now := time.Now()

	for i := 0; i < size; i++ {
		wg.Add(1)
		go func(i int) {
			defer wg.Done()
			owner := uuid.Must(uuid.NewV4()).String()
			var err error
			results[i], err = suite.repo.TryLock(context.Background(), "test-locker", owner, now.Add(time.Minute))
			suite.NoError(err)
		}(i)
	}
	wg.Wait()

	locksNumber := 0
	for _, result := range results {
		if result {
			locksNumber++
		}
	}
	suite.Equal(1, locksNumber)
}

func TestLocksRepo(t *testing.T) {
	suite.Run(t, new(LocksRepoTestSuite))
}
