import collections as col
import pymongo as mg
import pandas as pd
import matplotlib.pyplot as plt
import datetime


def round_minute(minute):
    return minute - minute % 10


cl = mg.MongoClient('sven.yandex.ru')

autoadmin_machines = []
with open('sas_autoadmin.txt') as list_of_machine:
    for machine in list_of_machine:
        autoadmin_machines.append(machine[:-1])

walle_mashines = []
with open('sas_walle.txt') as list_of_machine:
    for machine in list_of_machine:
        walle_mashines.append(machine[:-1])

dead_machine_walle = col.Counter()
dead_machine_autoadmin = col.Counter()
for element in cl['ssh']['hosts'].find():
    for date in element['fails']:
        key = (date.year, date.month, date.day, date.hour, round_minute(date.minute))
        if element['name'] in walle_mashines:
            dead_machine_walle[key] += 1
        else:
            dead_machine_autoadmin[key] += 1

columns = ['date', 'walle', 'autoadmin']
df_host = pd.DataFrame(columns=columns)
i = 0
for x in dead_machine_walle:
    year, month, day, hour, minute = x
    local_time = datetime.datetime.combine(datetime.date(year, month, day), datetime.time(hour, minute))
    df_host.loc[i] = (local_time, dead_machine_walle[x], dead_machine_autoadmin[x])
    i += 1
df_host.set_index('date', inplace=True)
df_host.sort_index(inplace=True)

cl = mg.MongoClient('sven.yandex.ru:27017')

dead_instance_walle = col.Counter()
dead_instance_autoadmin = col.Counter()
for element in cl['heartbeat']['hosts'].find():
    for date in element['alive_fails']:
        key = (date.year, date.month, date.day, date.hour, round_minute(date.minute))
        # print element['host']
        if element['host'] + '.search.yandex.net' in walle_mashines:
            dead_instance_walle[key] += 1
        else:
            dead_instance_autoadmin[key] += 1


columns = ['date', 'walle', 'autoadmin']
df_instance = pd.DataFrame(columns=columns)
i = 0
for x in dead_instance_walle:
    year, month, day, hour, minute = x
    local_time = datetime.datetime.combine(datetime.date(year, month, day), datetime.time(hour, minute))
    df_instance.loc[i] = (local_time, dead_instance_walle[x], dead_instance_autoadmin[x])
    i += 1
df_instance.set_index('date', inplace=True)
df_instance.sort_index(inplace=True)


plt.figsize(10, 5)

figure_hosts = plt.figure()
figure_hosts = df_host[datetime.datetime(2014, 12, 4, 20, 40) :].plot()
figure_hosts.get_xaxis().set_visible(False)

figure_instance = plt.figure()
figure_instance = df_instance[datetime.datetime(2014, 12, 4, 20, 40) :].plot()
figure_instance.get_xaxis().set_visible(False)
