import dataclasses

import juggler_sdk.check_sync
from sepelib.core import config


WALLE_JUGGLER_NAMESPACE = "wall-e.srv"
WALLE_ABC_SERVICE = "Wall-E"
WALLE_TESTING_ENV_NAME = "testing"
WALLE_PRODUCTION_ENV_NAME = "production"

CRON_JUGGLER_SERVICE = "wall-e.cron"
DMC_JUGGLER_SERVICE = "wall-e.dmc"
CHAT_NOTIFICATION_TAG = "dev-chat-notifications"


@dataclasses.dataclass
class UpdateResult:
    host: str
    service: str
    result: juggler_sdk.check_sync.ApplyCheckResult


def get_env():
    return config.get_value('environment.name')


def is_test():
    return get_env() == WALLE_TESTING_ENV_NAME


def get_ctype():
    if is_test():
        return "test"
    elif get_env() == WALLE_PRODUCTION_ENV_NAME:
        return "prod"
    else:
        return get_env()


def make_host() -> str:
    return f"wall-e.srv.{get_env()}"
